/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import panda.Formula;
import panda.FormulaBox;
import panda.Help;
import panda.LaTEX;
import panda.MrnatureApp;
import panda.PaletteForFormulas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaDialog
extends JDialog {
    boolean ok = false;
    private JButton cmdCancel;
    private JButton cmdHelp;
    private JButton cmdOK;
    private FormulaBox formulaBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private PaletteForFormulas paletteForFormulas1;
    private JPanel panFormulasHypotheses;
    private JPanel panPartieFormulasHypotheses;

    public FormulaDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setPreferredSize(new Dimension(500, 600));
        this.setMinimumSize(new Dimension(500, 400));
        this.formulaBox.setMinimumSize(new Dimension(1000, 100));
        this.formulaBox.setPreferredSize(new Dimension(1000, 100));
        this.cmdOK.setMnemonic(10);
        this.formulaBox.requestFocus();
        this.doLayout();
        this.getRootPane().setDefaultButton(this.cmdOK);
    }

    FormulaDialog(Frame parent, boolean b, Formula formula, Set<Formula> formulas) {
        this(parent, b);
        this.formulaBox.setText(formula.getSchemeString());
        this.formulaBox.selectAll();
        this.genererButtons(formulas);
    }

    FormulaDialog(Frame parent, boolean b, Set<Formula> formulas) {
        this(parent, b);
        this.genererButtons(formulas);
    }

    FormulaDialog(Frame parent, boolean b, Set<Formula> formulas, String string) {
        this(parent, b);
        this.genererButtons(formulas);
        this.setTitle(string);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.panPartieFormulasHypotheses = new JPanel();
        this.panFormulasHypotheses = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.paletteForFormulas1 = new PaletteForFormulas();
        this.formulaBox = new FormulaBox();
        this.jPanel2 = new JPanel();
        this.cmdOK = new JButton();
        this.cmdCancel = new JButton();
        this.cmdHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        this.jPanel5.setName("jPanel5");
        this.jPanel5.setLayout(new FlowLayout(0));
        this.panPartieFormulasHypotheses.setName("panPartieFormulasHypotheses");
        this.panPartieFormulasHypotheses.setLayout(new BoxLayout(this.panPartieFormulasHypotheses, 3));
        this.panFormulasHypotheses.setName("panFormulasHypotheses");
        this.panFormulasHypotheses.setLayout(new BoxLayout(this.panFormulasHypotheses, 3));
        this.panPartieFormulasHypotheses.add(this.panFormulasHypotheses);
        this.jPanel5.add(this.panPartieFormulasHypotheses);
        this.jPanel1.add(this.jPanel5);
        this.jPanel4.setName("jPanel4");
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setLayout(new BorderLayout());
        this.paletteForFormulas1.setMaximumSize(new Dimension(21313, 50));
        this.paletteForFormulas1.setName("paletteForFormulas1");
        this.jPanel3.add((Component)this.paletteForFormulas1, "First");
        this.formulaBox.setName("formulaBox");
        this.jPanel3.add((Component)this.formulaBox, "Center");
        this.jPanel4.add(this.jPanel3);
        this.jPanel1.add(this.jPanel4);
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout(new FlowLayout(0));
        ResourceMap resourceMap = Application.getInstance(MrnatureApp.class).getContext().getResourceMap(FormulaDialog.class);
        this.cmdOK.setIcon(resourceMap.getIcon("cmdOK.icon"));
        this.cmdOK.setText(resourceMap.getString("cmdOK.text", new Object[0]));
        this.cmdOK.setName("cmdOK");
        this.cmdOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormulaDialog.this.cmdOKActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdOK);
        this.cmdCancel.setIcon(resourceMap.getIcon("cmdCancel.icon"));
        this.cmdCancel.setText(resourceMap.getString("cmdCancel.text", new Object[0]));
        this.cmdCancel.setName("cmdCancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormulaDialog.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdCancel);
        this.cmdHelp.setIcon(resourceMap.getIcon("cmdHelp.icon"));
        this.cmdHelp.setText(resourceMap.getString("cmdHelp.text", new Object[0]));
        this.cmdHelp.setName("cmdHelp");
        this.cmdHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormulaDialog.this.cmdHelpActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdHelp);
        this.jPanel1.add(this.jPanel2);
        this.getContentPane().add(this.jPanel1);
        this.pack();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        if (this.formulaBox.isOK()) {
            this.ok = true;
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(null, "La formule est mal form\u00e9e. Tape quelque chose de correct !", "Erreur", 0);
        }
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.setVisible(false);
    }

    private void cmdHelpActionPerformed(ActionEvent evt) {
        Help.show("syntax.html");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FormulaDialog dialog = new FormulaDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    public Formula getFormula() {
        return this.formulaBox.getFormula();
    }

    private void genererButtons(Set<Formula> formulas) {
        for (final Formula formula : formulas) {
            JButton b;
            try {
                b = new JButton(LaTEX.latexCodeImageIconForButton(FormulaBox.formulaSchemeToLatexCode(formula)));
            }
            catch (Exception ex) {
                Logger.getLogger(FormulaDialog.class.getName()).log(Level.SEVERE, null, ex);
                b = null;
            }
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FormulaDialog.this.formulaBox.insert(formula.getSchemeString());
                }
            });
            this.panFormulasHypotheses.add(b);
        }
    }
}

