/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.util.HashSet;
import java.util.Set;
import jscheme.JScheme;
import jscheme.SchemePair;
import panda.FormulaBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formula {
    private static final JScheme jscheme = new JScheme();
    private final Object schemeFormula;

    public static Formula createAnd(Formula f1, Formula f2) {
        if (f1 == null) {
            return f2;
        }
        String s1 = f1.getSchemeString();
        if (f2 == null) {
            return f1;
        }
        String s2 = f2.getSchemeString();
        if (s1.isEmpty()) {
            s1 = "top";
        }
        if (s2.isEmpty()) {
            s2 = "top";
        }
        return new Formula("(" + s1 + " and " + s2 + ")");
    }

    public Formula(String schemeStyleFormulaText) {
        this.schemeFormula = jscheme.eval("'" + schemeStyleFormulaText);
    }

    private Formula(Object objectJScheme) {
        this.schemeFormula = objectJScheme;
    }

    public Formula getSubPart(int i) {
        return new Formula(((SchemePair)((SchemePair)this.schemeFormula).listTail(i)).first());
    }

    public int getNbSubParts() {
        return ((SchemePair)this.schemeFormula).length();
    }

    public String getSchemeString() {
        return this.schemeFormula.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Formula) {
            return this.getSchemeString().equals(((Formula)obj).getSchemeString());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.schemeFormula != null ? this.schemeFormula.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getSchemeString();
    }

    public boolean isPredicat() {
        return !this.isAnd() & !this.isOr() & !this.isExists() & !this.isForAll() & !this.isImply() & !this.isNot();
    }

    public boolean isQuantifiedFormula() {
        return this.isExists() || this.isForAll();
    }

    public boolean isAndOrOrOrImply() {
        return this.isAnd() || this.isOr() || this.isImply();
    }

    public boolean isAtomic() {
        return !this.getSchemeString().startsWith("(");
    }

    private boolean isBinaryOperator(String operatorName) {
        if (this.isAtomic()) {
            return false;
        }
        if (this.getNbSubParts() != 3) {
            return false;
        }
        return this.getSubPart(1).getSchemeString().equals(operatorName);
    }

    private boolean isUnaryPrefixOperator(String operatorName) {
        if (this.isAtomic()) {
            return false;
        }
        if (this.getNbSubParts() != 2) {
            return false;
        }
        return this.getSubPart(0).getSchemeString().equals(operatorName);
    }

    public boolean isImply() {
        return this.isBinaryOperator("imply");
    }

    public Formula getSubFormulaRight() {
        if (this.isBinaryOperator("equiv")) {
            return new Formula("(" + this.getSubPart(2) + " imply " + this.getSubPart(0) + ")");
        }
        return this.getSubPart(2);
    }

    public Formula getSubFormulaLeft() {
        if (this.isBinaryOperator("equiv")) {
            return new Formula("(" + this.getSubPart(0) + " imply " + this.getSubPart(2) + ")");
        }
        return this.getSubPart(0);
    }

    public boolean isAnd() {
        return this.isBinaryOperator("and") || this.isBinaryOperator("equiv");
    }

    public boolean isOr() {
        return this.isBinaryOperator("or");
    }

    public boolean isNot() {
        return this.isUnaryPrefixOperator("not");
    }

    public Formula getSubFormulaForNot() {
        return this.getSubPart(1);
    }

    boolean isBottom() {
        return this.getSchemeString().equals("bottom");
    }

    boolean isForAll() {
        if (this.isAtomic()) {
            return false;
        }
        if (this.getNbSubParts() != 3) {
            return false;
        }
        if (!this.getSubPart(0).getSchemeString().equals("forall")) {
            return false;
        }
        return this.getSubPart(1).isAtomic();
    }

    boolean isExists() {
        if (this.isAtomic()) {
            return false;
        }
        if (this.getNbSubParts() != 3) {
            return false;
        }
        if (!this.getSubPart(0).getSchemeString().equals("exists")) {
            return false;
        }
        return this.getSubPart(1).isAtomic();
    }

    public String getQuantifierVariable() {
        return this.getSubPart(1).getSchemeString();
    }

    public Formula getQuantifierSubFormula() {
        return this.getSubPart(2);
    }

    public boolean isFreeVariable(String variable) {
        if (this.isAnd() | this.isOr() | this.isImply()) {
            return this.getSubFormulaLeft().isFreeVariable(variable) | this.getSubFormulaRight().isFreeVariable(variable);
        }
        if (this.isNot()) {
            return this.getSubFormulaForNot().isFreeVariable(variable);
        }
        if (this.isForAll() | this.isExists()) {
            if (this.getQuantifierVariable().equals(variable)) {
                return false;
            }
            return this.getQuantifierSubFormula().isFreeVariable(variable);
        }
        return this.appears(variable);
    }

    public Set<String> getFreeVariables() {
        Set<String> V = this.getVariables();
        HashSet<String> VF = new HashSet<String>();
        for (String var : V) {
            if (!this.isFreeVariable(var)) continue;
            VF.add(var);
        }
        return VF;
    }

    public Set<String> getVariables() {
        if (this.isAnd() | this.isOr() | this.isImply()) {
            Set<String> S = this.getSubFormulaLeft().getVariables();
            S.addAll(this.getSubFormulaRight().getVariables());
            return S;
        }
        if (this.isNot()) {
            return this.getSubFormulaForNot().getVariables();
        }
        if (this.isForAll() | this.isExists()) {
            HashSet<String> S = new HashSet<String>();
            S.add(this.getQuantifierVariable());
            S.addAll(this.getQuantifierSubFormula().getVariables());
            return S;
        }
        if (this.isAtomic()) {
            HashSet<String> S = new HashSet<String>();
            return S;
        }
        HashSet<String> S = new HashSet<String>();
        for (int i = 1; i < this.getNbSubParts(); ++i) {
            S.addAll(Formula.getTermVariables(this.getSubPart(i)));
        }
        return S;
    }

    private boolean appears(String variable) {
        if (this.isAtomic()) {
            return this.getSchemeString().equals(variable);
        }
        for (int i = 0; i < this.getNbSubParts(); ++i) {
            if (!this.getSubPart(i).appears(variable)) continue;
            return true;
        }
        return false;
    }

    public Formula termSubstituer(String variable, Formula subFormula) {
        if (this.isAtomic()) {
            if (this.getSchemeString().equals(variable)) {
                return subFormula;
            }
            return this;
        }
        String s = "(" + this.getSubPart(0) + " ";
        for (int i = 1; i < this.getNbSubParts(); ++i) {
            s = s + this.getSubPart(i).termSubstituer(variable, subFormula) + " ";
        }
        s = s + ")";
        return new Formula(s);
    }

    public Formula substituer(String variable, Formula subFormula) {
        if (this.isAndOrOrOrImply()) {
            return new Formula("(" + this.getSubFormulaLeft().substituer(variable, subFormula) + " " + this.getBinaryOperator() + " " + this.getSubFormulaRight().substituer(variable, subFormula) + ")");
        }
        if (this.isNot()) {
            return new Formula("(not " + this.getSubFormulaForNot().substituer(variable, subFormula) + ")");
        }
        if (this.isQuantifiedFormula()) {
            if (this.getQuantifierVariable().equals(variable)) {
                return this;
            }
            return new Formula("(" + this.getQuantifier() + " " + this.getQuantifierVariable() + " " + this.getQuantifierSubFormula().substituer(variable, subFormula) + ")");
        }
        if (this.isAtomic()) {
            return this;
        }
        String s = "(" + this.getSubPart(0) + " ";
        for (int i = 1; i < this.getNbSubParts(); ++i) {
            s = s + this.getSubPart(i).termSubstituer(variable, subFormula) + " ";
        }
        s = s + ")";
        return new Formula(s);
    }

    public Formula unifiable(Formula pattern, String variable) {
        Formula term = this.brutalUnifiable(pattern, variable);
        if (term == null) {
            return null;
        }
        if (this.equals(pattern.substituer(variable, term))) {
            return term;
        }
        return null;
    }

    public Formula brutalUnifiable(Formula pattern, String variable) {
        if (pattern.isForAll() | pattern.isExists()) {
            if (!(this.isForAll() | this.isExists())) {
                return null;
            }
            if (!this.getSubPart(0).equals(this.getSubPart(0))) {
                return null;
            }
            if (!this.getSubPart(1).equals(this.getSubPart(1))) {
                return null;
            }
            if (this.getSubPart(1).getSchemeString().equals(variable)) {
                if (this.getSubPart(2).equals(pattern.getSubPart(2))) {
                    return new Formula("<?>");
                }
                return null;
            }
            return this.getSubPart(2).brutalUnifiable(pattern.getSubPart(2), variable);
        }
        if (pattern.isAtomic()) {
            if (pattern.getSchemeString().equals(variable)) {
                return this;
            }
            if (pattern.equals(this)) {
                return new Formula("<?>");
            }
            return null;
        }
        if (this.isAtomic()) {
            return null;
        }
        if (pattern.getNbSubParts() != this.getNbSubParts()) {
            return null;
        }
        if (pattern.getNbSubParts() == 0) {
            return new Formula("<?>");
        }
        Formula t = this.getSubPart(0).brutalUnifiable(pattern.getSubPart(0), variable);
        if (t == null) {
            return null;
        }
        for (int i = 0; i < this.getNbSubParts(); ++i) {
            Formula t2 = this.getSubPart(i).brutalUnifiable(pattern.getSubPart(i), variable);
            if (t2 == null) {
                return null;
            }
            if (t.isUndefined()) {
                t = t2;
                continue;
            }
            if (t2.isUndefined() || t.equals(t2)) continue;
            return null;
        }
        return t;
    }

    public boolean isUndefined() {
        return this.getSchemeString().startsWith("<");
    }

    public boolean isSaine(String variable, Formula t) {
        return this.isSaine(variable, t, new HashSet<String>());
    }

    private static Set<String> getTermVariables(Formula term) {
        HashSet<String> S = new HashSet<String>();
        Formula.putVariables(term, S);
        return S;
    }

    private boolean isSaine(String variable, Formula t, Set<String> setVariablesPortees) {
        if (this.isForAll() | this.isExists()) {
            HashSet<String> S = new HashSet<String>(setVariablesPortees);
            S.add(this.getQuantifierVariable());
            return this.getQuantifierSubFormula().isSaine(variable, t, S);
        }
        if (this.isAtomic()) {
            if (this.getSchemeString().equals(variable)) {
                return !setVariablesPortees.removeAll(Formula.getTermVariables(t));
            }
            return true;
        }
        for (int i = 0; i < this.getNbSubParts(); ++i) {
            if (this.getSubPart(i).isSaine(variable, t, setVariablesPortees)) continue;
            return false;
        }
        return true;
    }

    private static void putVariables(Formula term, Set<String> S) {
        if (term.isAtomic()) {
            S.add(term.getSchemeString());
        } else {
            for (int i = 1; i < term.getNbSubParts(); ++i) {
                Formula.putVariables(term.getSubPart(i), S);
            }
        }
    }

    boolean isNotNot() {
        if (!this.isNot()) {
            return false;
        }
        return this.getSubFormulaForNot().isNot();
    }

    public String getLaTEXCode() {
        try {
            return FormulaBox.formulaSchemeToLatexCode(this);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getBinaryOperator() {
        return this.getSubPart(1).getSchemeString();
    }

    private String getQuantifier() {
        return this.getSubPart(0).getSchemeString();
    }
}

