/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.util.Stack;
import panda.Command;
import panda.ProofPanel;

public class CommandsManager {
    private final ProofPanel proofPanel;
    private final Stack<Command> commandsPast = new Stack();
    private final Stack<Command> commandsFuture = new Stack();

    public CommandsManager(ProofPanel proofPanel) {
        this.proofPanel = proofPanel;
    }

    public void execute(Command command) {
        command.execute(this.proofPanel);
        this.commandsPast.push(command);
        this.commandsFuture.clear();
    }

    public void undoLastCommand() {
        if (this.commandsPast.empty()) {
            return;
        }
        Command c = this.commandsPast.pop();
        c.undo(this.proofPanel);
        this.commandsFuture.push(c);
    }

    public void redoNextCommand() {
        if (this.commandsFuture.empty()) {
            return;
        }
        Command c = this.commandsFuture.pop();
        c.execute(this.proofPanel);
        this.commandsPast.push(c);
    }

    public void clear() {
        this.commandsFuture.clear();
        this.commandsPast.clear();
    }
}

