/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import panda.Formula;
import panda.LaTEX;
import panda.MrnatureApp;
import panda.SchemeFormulaTextField;

public abstract class AbstractFormulaBox
extends JPanel {
    private static AbstractFormulaBox focusOwnerformulaBox = null;
    private JLabel jLabel1;
    private JLabel lblAffichage;
    private JLabel lblError;
    private SchemeFormulaTextField txtFormula;

    static AbstractFormulaBox getFocusOwnerFormulaBox() {
        return focusOwnerformulaBox;
    }

    public static String formulaSchemeStringToLatexCode(String formula) throws Exception {
        return AbstractFormulaBox.formulaSchemeToLatexCode(new Formula(formula));
    }

    protected abstract String textToLatexCode(Formula var1) throws Exception;

    public static String formulaSchemeToLatexCode(Formula formula) throws Exception {
        if (formula.getSchemeString().startsWith("<")) {
            return "?";
        }
        if (formula.getSchemeString().equals("top")) {
            return "\\top";
        }
        if (formula.getSchemeString().equals("bottom")) {
            return "\\bot";
        }
        if (!formula.getSchemeString().startsWith("(")) {
            return AbstractFormulaBox.predicatToLaTEX(formula);
        }
        if (formula.isNot()) {
            return "\\neg " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubFormulaForNot());
        }
        if (formula.getSubPart(1).getSchemeString().equals("and")) {
            if (formula.getNbSubParts() % 2 == 0) {
                throw new Exception("Il manque au moins une sous-formule dans cette conjonction");
            }
            String s = "\\left(" + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(0));
            for (int i = 1; i < formula.getNbSubParts(); i += 2) {
                if (!formula.getSubPart(i).toString().equals("and")) {
                    throw new Exception("J'attends un 'and'");
                }
                s = s + " \\wedge " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(i + 1));
            }
            s = s + "\\right)";
            return s;
        }
        if (formula.getSubPart(1).getSchemeString().equals("or")) {
            if (formula.getNbSubParts() % 2 == 0) {
                throw new Exception("Il manque au moins une sous-formule dans cette conjonction");
            }
            String s = "\\left(" + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(0));
            for (int i = 1; i < formula.getNbSubParts(); i += 2) {
                if (!formula.getSubPart(i).toString().equals("or")) {
                    throw new Exception("J'attends un 'or'");
                }
                s = s + " \\vee " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(i + 1));
            }
            s = s + "\\right)";
            return s;
        }
        if (formula.getSubPart(1).getSchemeString().equals("imply")) {
            return "\\left(" + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(0)) + " \\rightarrow " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(2)) + "\\right)";
        }
        if (formula.getSubPart(1).getSchemeString().equals("equiv")) {
            return "\\left(" + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(0)) + " \\leftrightarrow " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getSubPart(2)) + "\\right)";
        }
        if (formula.isForAll()) {
            return "\\forall " + AbstractFormulaBox.variableToLatexCode(formula.getQuantifierVariable()) + ". " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getQuantifierSubFormula());
        }
        if (formula.isExists()) {
            return "\\exists " + AbstractFormulaBox.variableToLatexCode(formula.getQuantifierVariable()) + ". " + AbstractFormulaBox.formulaSchemeToLatexCode(formula.getQuantifierSubFormula());
        }
        return AbstractFormulaBox.predicatToLaTEX(formula);
    }

    private static String conditionToLatexCode(String conditionText) {
        return conditionText.replaceAll(" diff ", Matcher.quoteReplacement(" \\neq "));
    }

    protected static String termToLaTeX(Formula term) {
        if (term.isAtomic()) {
            return "{" + term.getSchemeString() + "}";
        }
        if (term.getNbSubParts() == 1) {
            return term.getSchemeString();
        }
        String s = "";
        s = s + term.getSubPart(0);
        s = s + "(";
        s = s + AbstractFormulaBox.termToLaTeX(term.getSubPart(1));
        for (int i = 2; i < term.getNbSubParts(); ++i) {
            s = s + ", ";
            s = s + AbstractFormulaBox.termToLaTeX(term.getSubPart(i));
        }
        s = s + ")";
        return s;
    }

    public static String predicatSymbolToLaTEX(String predicatName) {
        return "\\mathbf{" + predicatName + "}";
    }

    private static String predicatToLaTEX(Formula predicat) {
        if (predicat.isAtomic()) {
            return AbstractFormulaBox.predicatSymbolToLaTEX(predicat.getSchemeString());
        }
        if (predicat.getNbSubParts() == 1) {
            return predicat.getSchemeString();
        }
        String s = "";
        s = s + AbstractFormulaBox.predicatSymbolToLaTEX(predicat.getSubPart(0).getSchemeString());
        s = s + "(";
        s = s + AbstractFormulaBox.termToLaTeX(predicat.getSubPart(1));
        for (int i = 2; i < predicat.getNbSubParts(); ++i) {
            s = s + ", ";
            s = s + AbstractFormulaBox.termToLaTeX(predicat.getSubPart(i));
        }
        s = s + ")";
        return s;
    }

    private static String variableToLatexCode(String var) {
        if (var.startsWith("<")) {
            return "?";
        }
        return var;
    }

    public AbstractFormulaBox() {
        this.initComponents();
        this.lblError.setVisible(false);
        this.lblAffichage.setText("");
    }

    public void requestFocus() {
        super.requestFocus();
        this.txtFormula.requestFocus();
    }

    private void initComponents() {
        this.txtFormula = new SchemeFormulaTextField();
        this.lblError = new JLabel();
        this.lblAffichage = new JLabel();
        this.jLabel1 = new JLabel();
        this.setName("Form");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AbstractFormulaBox.this.formFocusGained(evt);
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.txtFormula.setAlignmentX(0.0f);
        ResourceMap resourceMap = Application.getInstance(MrnatureApp.class).getContext().getResourceMap(AbstractFormulaBox.class);
        this.txtFormula.setFont(resourceMap.getFont("txtFormula.font"));
        this.txtFormula.setMaximumSize(new Dimension(Integer.MAX_VALUE, 28));
        this.txtFormula.setName("txtFormula");
        this.txtFormula.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AbstractFormulaBox.this.txtFormulaMouseClicked(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AbstractFormulaBox.this.txtFormulaMouseReleased(evt);
            }
        });
        this.txtFormula.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AbstractFormulaBox.this.txtFormulaFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                AbstractFormulaBox.this.txtFormulaFocusLost(evt);
            }
        });
        this.txtFormula.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AbstractFormulaBox.this.txtFormulaKeyReleased(evt);
            }
        });
        this.add(this.txtFormula);
        this.lblError.setForeground(resourceMap.getColor("lblError.foreground"));
        this.lblError.setName("lblError");
        this.add(this.lblError);
        this.lblAffichage.setName("lblAffichage");
        this.lblAffichage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AbstractFormulaBox.this.lblAffichageMouseClicked(evt);
            }
        });
        this.add(this.lblAffichage);
        this.jLabel1.setMaximumSize(new Dimension(33, 22));
        this.jLabel1.setMinimumSize(new Dimension(33, 22));
        this.jLabel1.setName("jLabel1");
        this.jLabel1.setPreferredSize(new Dimension(33, 22));
        this.add(this.jLabel1);
    }

    private void txtFormulaKeyReleased(KeyEvent evt) {
        this.txtFormula.doRepaint();
        this.mettreAJourAffichageLatex();
    }

    private void txtFormulaMouseClicked(MouseEvent evt) {
        this.txtFormula.doRepaint();
        this.mettreAJourAffichageLatex();
    }

    private void lblAffichageMouseClicked(MouseEvent evt) {
        System.out.println(this.getFormula().getSchemeString());
    }

    private void txtFormulaFocusLost(FocusEvent evt) {
        this.txtFormula.repaint();
    }

    private void formFocusGained(FocusEvent evt) {
        focusOwnerformulaBox = this;
    }

    private void txtFormulaFocusGained(FocusEvent evt) {
        focusOwnerformulaBox = this;
    }

    private void txtFormulaMouseReleased(MouseEvent evt) {
        this.txtFormula.doRepaint();
    }

    private String aCompleter() {
        String s = this.getText();
        int a = s.indexOf("<");
        if (a < 0) {
            return null;
        }
        int b = s.indexOf(">", a);
        return s.substring(a, b + 1);
    }

    private int indiceAvecErreurParenthese() {
        String s = this.getText();
        int compteur = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '(') {
                ++compteur;
            }
            if (s.charAt(i) == ')') {
                --compteur;
            }
            if (compteur >= 0) continue;
            return i;
        }
        if (compteur > 0) {
            return -2;
        }
        return -1;
    }

    private void mettreAJourAffichageLatex() {
        this.lblError.setVisible(false);
        this.txtFormula.noError();
        this.lblAffichage.setText("");
        int i = this.indiceAvecErreurParenthese();
        if (i >= 0) {
            this.afficherMessageErreur("parenth\u00e8se fermante en trop au caract\u00e8re n\u00b0" + i);
            this.txtFormula.error(i);
            return;
        }
        if (i == -2) {
            this.afficherMessageErreur("parenth\u00e8se ouvrante en trop mais je ne sais pas o\u00f9");
            return;
        }
        String s = this.aCompleter();
        if (s != null) {
            this.afficherMessageConseil("Remplace " + s + " par quelquechose !");
        }
        try {
            if (!this.txtFormula.getText().isEmpty()) {
                Formula formula = new Formula("(" + this.txtFormula.getText() + ")");
                if (formula.getNbSubParts() > 1) {
                    this.txtFormula.errorAll();
                    throw new Exception("Tu dois mettre des parenth\u00e8ses autour tout \u00e7a ! L\u00e0, je lis '" + formula.getSubPart(0).toString() + "' puis '" + formula.getSubPart(1).toString() + "' et je ne comprends pas");
                }
                this.lblAffichage.setIcon(LaTEX.latexCodeToImageIcon(this.textToLatexCode(formula.getSubPart(0))));
                this.lblAffichage.setVisible(true);
            } else {
                this.lblAffichage.setIcon(null);
            }
        }
        catch (Exception e) {
            this.afficherMessageErreur(e.getMessage());
        }
    }

    public boolean isOK() {
        return !this.txtFormula.getText().isEmpty() & !this.lblError.isVisible();
    }

    private void afficherMessageErreur(String s) {
        this.lblAffichage.setVisible(false);
        this.lblError.setVisible(true);
        this.lblError.setText("Error: " + s);
    }

    private void afficherMessageConseil(String s) {
        this.lblError.setVisible(true);
        this.lblError.setText("Conseil : " + s);
    }

    public String getText() {
        return this.txtFormula.getText();
    }

    public Formula getFormula() {
        if (this.getText().isEmpty()) {
            return null;
        }
        return new Formula(this.getText());
    }

    public void setText(String string) {
        this.txtFormula.setText(string);
        this.mettreAJourAffichageLatex();
    }

    public void insert(String texte) {
        this.txtFormula.replaceSelection(texte);
        this.mettreAJourAffichageLatex();
    }

    public boolean isFocusOwner() {
        return super.isFocusOwner() || this.txtFormula.isFocusOwner();
    }

    public boolean isEmpty() {
        return this.getText().isEmpty();
    }

    void selectAll() {
        this.txtFormula.selectAll();
    }
}

