/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import jsint.Continuation;
import jsint.ContinuationException;
import jsint.E;
import jsint.Import;
import jsint.InputPort;
import jsint.Pair;
import jsint.Procedure;
import jsint.Queue;
import jsint.Scheme;
import jsint.Symbol;

public abstract class U {
    public static boolean useJavaSyntax = true;
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    public static final Symbol UNDEFINED = Symbol.intern("#!undefined");
    public static final Symbol MISSING = Symbol.intern("#!missing");
    public static final Object[] NO_ARGS = new Object[0];
    public static final Object[] EMPTY_ARGS = new Object[]{Pair.EMPTY};
    private static final int NUM_CACHED = 128;
    private static final Character[] cachedCharacters = new Character[128];
    private static final Integer[] cachedPosInts = new Integer[128];
    private static final Integer[] cachedNegInts = new Integer[128];
    public static final Double ZERO = new Double(0.0);
    public static final Double ONE = new Double(1.0);
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$jsint$Symbol;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static boolean isFalse(Object x) {
        return x == null || FALSE.equals(x);
    }

    public static Object and1(Object x) {
        return U.isFalse(x) ? FALSE : x;
    }

    public static boolean to_bool(Object x) {
        return !U.isFalse(x);
    }

    public static Boolean toBool(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static Boolean toBool(Object x) {
        return U.isFalse(x) ? FALSE : TRUE;
    }

    public static Boolean not(Object x) {
        return U.isFalse(x) ? TRUE : FALSE;
    }

    public static char to_char(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return U.to_char(E.typeError("char", x));
    }

    public static char to_lc_char(Object x) {
        if (x instanceof Character) {
            return Character.toLowerCase(((Character)x).charValue());
        }
        return U.to_lc_char(E.typeError("char", x));
    }

    public static Character toChar(char ch) {
        if (ch < '\u0080') {
            Character c = cachedCharacters[ch];
            return c != null ? c : new Character(ch);
        }
        return new Character(ch);
    }

    public static Class toClass(Object c) {
        if (c instanceof Class) {
            return (Class)c;
        }
        return Import.classNamed(U.stringify(c, false));
    }

    public static Class maybeToClass(Object c) {
        if (c instanceof Class) {
            return (Class)c;
        }
        return Import.maybeClassNamed(U.stringify(c, false));
    }

    public static Integer toNum(int i) {
        if (i >= 0) {
            if (i < 128) {
                Integer in = cachedPosInts[i];
                return in != null ? in : new Integer(i);
            }
            return new Integer(i);
        }
        if (i > -128) {
            Integer in = cachedNegInts[-i];
            return in != null ? in : (U.cachedNegInts[-i] = new Integer(i));
        }
        return new Integer(i);
    }

    public static Number toNum(long i) {
        if (i <= Integer.MAX_VALUE && i >= Integer.MIN_VALUE) {
            return U.toNum((int)i);
        }
        return new Long(i);
    }

    public static Double toNum(double x) {
        return x == 0.0 ? ZERO : (x == 1.0 ? ONE : new Double(x));
    }

    public static double toReal(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        return U.toReal(E.typeError("real number", x));
    }

    public static int toInt(Object x) {
        try {
            return ((Number)x).intValue();
        }
        catch (ClassCastException e) {
            return U.toInt(E.typeError("integer", x));
        }
    }

    public static int toInt(Object x, int defaultVal) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return defaultVal;
    }

    public static String toStr(Object x) {
        return x instanceof String ? (String)x : U.toStr(E.typeError("string", x));
    }

    public static Symbol toSym(Object x) {
        if (x instanceof Symbol) {
            return (Symbol)x;
        }
        return U.toSym(E.typeError("symbol", x));
    }

    public static Procedure toProc(Object x) {
        try {
            return (Procedure)x;
        }
        catch (ClassCastException e) {
            return U.toProc(E.typeError("procedure", x));
        }
    }

    public static boolean isPair(Object x) {
        return x instanceof Pair && x != Pair.EMPTY;
    }

    public static Pair toPair(Object x) {
        try {
            if (x != Pair.EMPTY) {
                return (Pair)x;
            }
            return U.toPair(E.typeError("pair(i.e. non-empty list)", x));
        }
        catch (ClassCastException e) {
            return U.toPair(E.typeError("pair(i.e. non-empty list)", x));
        }
    }

    public static Pair toList(Object x) {
        try {
            return (Pair)x;
        }
        catch (ClassCastException e) {
            return U.toPair(E.typeError("list (i.e. pair or empty)", x));
        }
    }

    public static InputPort toInPort(Object x) {
        if (x == MISSING) {
            return Scheme.currentEvaluator().getInput();
        }
        if (x instanceof InputPort) {
            return (InputPort)x;
        }
        return U.toInPort(E.typeError("input port", x));
    }

    public static PrintWriter toOutPort(Object x) {
        if (x == MISSING) {
            return Scheme.currentEvaluator().getOutput();
        }
        if (x instanceof PrintWriter) {
            return (PrintWriter)x;
        }
        return U.toOutPort(E.typeError("output port", x));
    }

    public static Object first(Object x) {
        return U.toPair((Object)x).first;
    }

    public static Object rest(Object x) {
        return U.toPair((Object)x).rest;
    }

    public static Object second(Object x) {
        return U.toPair(x).second();
    }

    public static Pair list(Object a, Object b, Object c) {
        return new Pair(a, new Pair(b, new Pair(c, Pair.EMPTY)));
    }

    public static Pair list(Object a, Object b) {
        return new Pair(a, new Pair(b, Pair.EMPTY));
    }

    public static Pair list(Object a) {
        return new Pair(a, Pair.EMPTY);
    }

    public static boolean equal(Object x, Object y) {
        if (x == null || y == null) {
            return x == y;
        }
        if (x == Pair.EMPTY || y == Pair.EMPTY) {
            return x == y;
        }
        if (x instanceof Object[]) {
            if (!(y instanceof Object[])) {
                return false;
            }
            Object[] xo = (Object[])x;
            Object[] yo = (Object[])y;
            if (xo.length != yo.length) {
                return false;
            }
            for (int i = xo.length - 1; i >= 0; --i) {
                if (U.equal(xo[i], yo[i])) continue;
                return false;
            }
            return true;
        }
        return x.equals(y) || U.eqv(x, y);
    }

    public static boolean eqv(Object x, Object y) {
        return x == y || x == null && y == null || x != null && y != null && U.sameAtomicClasses(x.getClass(), y.getClass()) && x.equals(y);
    }

    private static boolean sameAtomicClasses(Class cx, Class cy) {
        return cx == cy && (cx.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = U.class$("java.lang.Number")) : class$java$lang$Number) || cx == (class$jsint$Symbol == null ? (class$jsint$Symbol = U.class$("jsint.Symbol")) : class$jsint$Symbol) || cx == (class$java$lang$Character == null ? (class$java$lang$Character = U.class$("java.lang.Character")) : class$java$lang$Character) || cx == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = U.class$("java.lang.Boolean")) : class$java$lang$Boolean));
    }

    public static Object write(Object x, PrintWriter port, boolean quoted) {
        port.print(U.stringify(x, quoted));
        port.flush();
        return x;
    }

    public static boolean checkNargs(int min, int max, int given, Object form) {
        if (given >= min && given <= max) {
            return true;
        }
        E.warn("expected " + min + (min == max ? "" : (max == Integer.MAX_VALUE ? " or more" : " to " + max)) + " arguments, but got " + given, form);
        return false;
    }

    public static StringBuffer stringify(Object x, boolean quoted, StringBuffer buf) {
        if (x == Pair.EMPTY) {
            buf.append("()");
        } else if (x == null) {
            buf.append("#null");
        } else if (x instanceof Boolean) {
            if (Boolean.TRUE.equals(x)) {
                buf.append("#t");
            } else {
                buf.append("#f");
            }
        } else if (x == TRUE) {
            buf.append("#t");
        } else if (x == FALSE) {
            buf.append("#f");
        } else if (x instanceof Pair) {
            ((Pair)x).stringifyPair(quoted, buf);
        } else if (x instanceof Character) {
            char ch = ((Character)x).charValue();
            if (ch == '\'') {
                buf.append(quoted ? (useJavaSyntax ? "#'\\''" : "#\\'") : "'");
            } else if (useJavaSyntax) {
                if (quoted) {
                    buf.append("#'");
                }
                U.stringifyChar(buf, ch, quoted);
                if (quoted) {
                    buf.append("'");
                }
            } else {
                if (quoted) {
                    buf.append("#\\");
                }
                if (quoted && (ch == ' ' || ch == '\n')) {
                    buf.append(ch == ' ' ? "space" : "newline");
                } else {
                    buf.append(ch);
                }
            }
        } else if (x instanceof String) {
            String s = (String)x;
            if (quoted) {
                buf.append('\"');
            }
            if (useJavaSyntax) {
                for (int i = 0; i < s.length(); ++i) {
                    U.stringifyChar(buf, s.charAt(i), quoted);
                }
            } else {
                for (int i = 0; i < s.length(); ++i) {
                    if (quoted && (s.charAt(i) == '\"' || s.charAt(i) == '\\')) {
                        buf.append('\\');
                    }
                    buf.append(s.charAt(i));
                }
            }
            if (quoted) {
                buf.append('\"');
            }
        } else if (x instanceof Object[]) {
            Object[] v = (Object[])x;
            buf.append("#(");
            for (int i = 0; i < v.length; ++i) {
                U.stringify(v[i], quoted, buf);
                if (i == v.length - 1) continue;
                buf.append(' ');
            }
            buf.append(')');
        } else if (x instanceof Number) {
            buf.append(x);
            if (!(x instanceof Integer) && !(x instanceof Double)) {
                if (x instanceof Byte) {
                    buf.append("B");
                } else if (x instanceof Short) {
                    buf.append("S");
                } else if (x instanceof Long) {
                    buf.append("L");
                } else if (x instanceof Float) {
                    buf.append("F");
                }
            }
        } else {
            buf.append(x);
        }
        return buf;
    }

    private static void stringifyChar(StringBuffer buf, char ch, boolean quoted) {
        switch (ch) {
            case '\b': {
                buf.append(quoted ? "\\b" : "\b");
                break;
            }
            case '\t': {
                buf.append(quoted ? "\\t" : "\t");
                break;
            }
            case '\n': {
                buf.append(quoted ? "\\n" : "\n");
                break;
            }
            case '\f': {
                buf.append(quoted ? "\\f" : "\f");
                break;
            }
            case '\r': {
                buf.append(quoted ? "\\r" : "\r");
                break;
            }
            case '\"': {
                buf.append(quoted ? "\\\"" : "\"");
                break;
            }
            case '\\': {
                buf.append(quoted ? "\\\\" : "\\");
                break;
            }
            default: {
                buf.append(ch);
            }
        }
    }

    public static String stringify(Object x) {
        return U.stringify(x, true);
    }

    public static String stringify(Object x, boolean quoted) {
        if (x instanceof String && !quoted) {
            return (String)x;
        }
        if (x instanceof Symbol) {
            return ((Symbol)x).toString();
        }
        return U.stringify(x, quoted, new StringBuffer()).toString();
    }

    public static String makeString(int size, Object fill) {
        char[] chars = new char[size];
        if (fill != MISSING) {
            char ch = U.to_char(fill);
            for (int i = 0; i < size; ++i) {
                chars[i] = ch;
            }
        }
        return new String(chars);
    }

    public static String stringAppend(Pair args) {
        if (args == Pair.EMPTY) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        while (args != Pair.EMPTY) {
            if (Scheme.isInterruptable()) {
                Scheme.interruptCheck();
            }
            result.append(U.stringify(args.first, false));
            args = U.toList(args.rest);
        }
        return result.toString();
    }

    public static Object memberAssoc(Object obj, Object list, boolean member, int eq) {
        boolean found = false;
        while (U.isPair(list)) {
            if (Scheme.isInterruptable()) {
                Scheme.interruptCheck();
            }
            Object target = member ? U.first(list) : U.first(U.first(list));
            switch (eq) {
                case 1: {
                    found = target == obj;
                    break;
                }
                case 2: {
                    found = U.eqv(target, obj);
                    break;
                }
                case 3: {
                    found = U.equal(target, obj);
                    break;
                }
                default: {
                    E.warn("Bad option to memberAssoc:" + eq);
                    return FALSE;
                }
            }
            if (found) {
                return member ? list : U.first(list);
            }
            list = U.rest(list);
        }
        return FALSE;
    }

    public static Object numCompute(Object x, Pair args, char op) {
        return x instanceof Integer ? U.numCompute(U.toInt(x), args, op) : U.numCompute(U.toReal(x), args, op);
    }

    public static Object numCompute(long result, Pair args, char op) {
        while (U.isPair(args)) {
            if (!(args.first instanceof Integer)) {
                return U.numCompute((double)result, args, op);
            }
            long y = U.toInt(args.first);
            switch (op) {
                case '>': {
                    if (result <= y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '<': {
                    if (result >= y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '=': {
                    if (result != y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'L': {
                    if (result > y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'G': {
                    if (result < y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'X': {
                    if (y <= result) break;
                    result = y;
                    break;
                }
                case 'N': {
                    if (y >= result) break;
                    result = y;
                    break;
                }
                case '+': {
                    result += y;
                    break;
                }
                case '-': {
                    result -= y;
                    break;
                }
                case '*': {
                    result *= y;
                    break;
                }
                case '/': {
                    if (result % y == 0L) {
                        result /= y;
                        break;
                    }
                    return U.numCompute((double)result, args, op);
                }
                default: {
                    return E.error("internal error: unrecognized op: " + op);
                }
            }
            if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
                return U.numCompute((double)result, args, op);
            }
            args = U.toList(args.rest);
        }
        return U.toNum(result);
    }

    public static Object numCompute(double result, Pair args, char op) {
        while (U.isPair(args)) {
            double y = U.toReal(args.first);
            switch (op) {
                case '>': {
                    if (!(result > y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '<': {
                    if (!(result < y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case '=': {
                    if (result != y) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'L': {
                    if (!(result <= y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'G': {
                    if (!(result >= y)) {
                        return FALSE;
                    }
                    result = y;
                    break;
                }
                case 'X': {
                    if (!(y > result)) break;
                    result = y;
                    break;
                }
                case 'N': {
                    if (!(y < result)) break;
                    result = y;
                    break;
                }
                case '+': {
                    result += y;
                    break;
                }
                case '-': {
                    result -= y;
                    break;
                }
                case '*': {
                    result *= y;
                    break;
                }
                case '/': {
                    result /= y;
                    break;
                }
                default: {
                    return E.error("internal error: unrecognized op: " + op);
                }
            }
            args = U.toList(args.rest);
        }
        return U.toNum(result);
    }

    public static Object numberToString(Object x, Object y) {
        int base;
        int n = base = y instanceof Number ? U.toInt(y) : 10;
        if (base != 10 && x instanceof Integer) {
            return Long.toString(U.toInt(x), base);
        }
        return x.toString();
    }

    public static Object stringToNumber(Object x, Object y) {
        return InputPort.schemeStringToNumber(U.stringify(x, false), y instanceof Number ? U.toInt(y) : 10);
    }

    public static Object stringToList(Object x) {
        Pair result = Pair.EMPTY;
        String str = U.toStr(x);
        for (int i = str.length() - 1; i >= 0; --i) {
            result = new Pair(U.toChar(str.charAt(i)), result);
        }
        return result;
    }

    public static String listToString(Object chars) {
        char[] str = new char[U.toList(chars).length()];
        int i = 0;
        while (U.isPair(chars)) {
            str[i] = U.to_char(U.first(chars));
            chars = U.rest(chars);
            ++i;
        }
        return new String(str);
    }

    public static int stringCompareIgnoreCase(Object x, Object y) {
        String xs = U.toStr(x);
        String ys = U.toStr(y);
        for (int i = 0; i < xs.length(); ++i) {
            int diff = Character.toUpperCase(xs.charAt(i)) - Character.toUpperCase(ys.charAt(i));
            if (diff == 0) continue;
            return diff;
        }
        return xs.length() - ys.length();
    }

    public static long gcd(Pair args) {
        return args.rest == Pair.EMPTY ? (long)U.toInt(args.first) : U.gcd(Math.abs(U.toInt(args.first)), U.gcd((Pair)args.rest));
    }

    static long gcd(long a, long b) {
        return b == 0L ? a : U.gcd(b, a % b);
    }

    static long lcm(Object args) {
        long L = 1L;
        long g = 1L;
        while (U.isPair(args)) {
            long n = Math.abs((long)U.toInt(U.first(args)));
            g = U.gcd(n, L);
            L = g == 0L ? g : n / g * L;
            args = U.toList(U.rest(args));
        }
        return L;
    }

    public static PrintWriter openOutputFile(Object filename) {
        try {
            return new PrintWriter(new FileWriter(U.stringify(filename, false)));
        }
        catch (FileNotFoundException e) {
            return (PrintWriter)E.error(e.toString());
        }
        catch (IOException e) {
            return (PrintWriter)E.error("IOException: " + e);
        }
    }

    public static InputPort openInputFile(Object filename) {
        return Scheme.open(U.toStr(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithInputFile(Object filename, Procedure proc) {
        InputPort in = null;
        Object result = null;
        try {
            in = U.openInputFile(filename);
            if (in == null) {
                E.error("could not find '" + filename + "' as a resource URL, or File.");
            }
            result = proc.apply(U.list(in));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithOutputFile(Object filename, Procedure proc) {
        PrintWriter out = null;
        Object result = null;
        try {
            out = U.openOutputFile(filename);
            result = proc.apply(U.list(out));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return result;
    }

    public static boolean isList(Object x) {
        Object slow = x;
        Object fast = x;
        while (fast != Pair.EMPTY) {
            if (!U.isPair(fast) || !U.isPair(slow) || slow == U.rest(fast)) {
                return false;
            }
            slow = U.rest(slow);
            if ((fast = U.rest(fast)) == Pair.EMPTY) {
                return true;
            }
            if (!U.isPair(fast)) {
                return false;
            }
            fast = U.rest(fast);
        }
        return true;
    }

    public static Object append(Object args) {
        if (U.isPair(args)) {
            Queue queue = new Queue();
            while (U.isPair(U.rest(args))) {
                if (Scheme.isInterruptable()) {
                    Scheme.interruptCheck();
                }
                Object x = U.first(args);
                while (U.isPair(x)) {
                    queue.add(U.first(x));
                    x = U.rest(x);
                }
                args = U.rest(args);
            }
            queue.getLast().rest = U.first(args);
            return queue.getContent();
        }
        return args;
    }

    public static Object callCC(Procedure k) {
        ContinuationException cc = new ContinuationException();
        Continuation proc = new Continuation(cc);
        try {
            return k.apply(U.list(proc));
        }
        catch (ContinuationException e) {
            if (e == cc) {
                return proc.value;
            }
            throw e;
        }
    }

    public static Pair map(Procedure proc, Object args, Pair result) {
        Pair end = result;
        if (U.rest(args) == Pair.EMPTY) {
            Object argList = U.first(args);
            while (U.isPair(argList)) {
                if (Scheme.isInterruptable()) {
                    Scheme.interruptCheck();
                }
                Object x = proc.apply(U.list(U.first(argList)));
                if (end != Pair.EMPTY) {
                    end.rest = U.list(x);
                    end = end.rest;
                }
                argList = U.rest(argList);
            }
        } else {
            Procedure car = U.toProc(Symbol.CAR.getGlobalValue());
            Procedure cdr = U.toProc(Symbol.CDR.getGlobalValue());
            while (U.isPair(U.first(args))) {
                if (Scheme.isInterruptable()) {
                    Scheme.interruptCheck();
                }
                Object x = proc.apply(U.map(car, U.list(args), U.list(TRUE)));
                if (end != Pair.EMPTY) {
                    end.rest = U.list(x);
                    end = end.rest;
                }
                args = U.map(cdr, U.list(args), U.list(TRUE));
            }
        }
        return U.isPair(result) ? (Pair)U.rest(result) : result;
    }

    public static Pair timeCall(Procedure proc, int nTimes) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long startTime = System.currentTimeMillis();
        long startMem = runtime.freeMemory();
        Object ans = FALSE;
        for (int i = 0; i < nTimes; ++i) {
            ans = proc.apply(Pair.EMPTY);
        }
        long time = System.currentTimeMillis() - startTime;
        long mem = startMem - runtime.freeMemory();
        return new Pair(ans, U.list(U.list(U.toNum(time), Symbol.intern("msec")), U.list(U.toNum(mem), Symbol.intern("bytes"))));
    }

    public static Object p(String x, Object y) {
        if (Symbol.intern("debug").getGlobalValue() == TRUE) {
            Scheme.currentEvaluator().getError().println(x + U.stringify(y));
        }
        return y;
    }

    public static Object toVec(Object x) {
        return x instanceof Object[] ? x : (x != null && x.getClass().isArray() ? x : E.typeError("vector", x));
    }

    public static boolean isVector(Object x) {
        return x instanceof Object[] || x != null && x.getClass().isArray();
    }

    public static Object makeVector(Object x) {
        return new Object[U.toInt(x)];
    }

    public static Object makeVector(Object x, Object fill) {
        Object[] v = new Object[U.toInt(x)];
        for (int i = 0; i < U.toInt(x); ++i) {
            v[i] = fill;
        }
        return v;
    }

    public static Object vectorFill(Object vec, Object fill) {
        for (int i = Array.getLength(vec) - 1; i >= 0; --i) {
            Array.set(vec, i, fill);
        }
        return UNDEFINED;
    }

    public static Object vectorLength(Object x) {
        return x instanceof Object[] ? U.toNum(((Object[])x).length) : (x != null && x.getClass().isArray() ? U.toNum(Array.getLength(x)) : E.typeError("vector", x));
    }

    public static Object vectorRef(Object x, Object y) {
        return x instanceof Object[] ? ((Object[])x)[U.toInt(y)] : (x != null && x.getClass().isArray() ? Array.get(x, U.toInt(y)) : E.typeError("vector", x));
    }

    public static Object vectorSet(Object x, Object y, Object z) {
        if (x instanceof Object[]) {
            Object object = z;
            ((Object[])x)[U.toInt((Object)y)] = object;
            return object;
        }
        if (x != null && x.getClass().isArray()) {
            Array.set(x, U.toInt(y), z);
            return z;
        }
        return E.typeError("vector", x);
    }

    public static Pair vectorToList(Object vec) {
        Pair result = Pair.EMPTY;
        for (int i = Array.getLength(vec) - 1; i >= 0; --i) {
            result = new Pair(Array.get(vec, i), result);
        }
        return result;
    }

    public static Object[] listToVector(Object x) {
        Pair list = U.toList(x);
        int L = list.length();
        Object[] result = new Object[L];
        int i = 0;
        while (U.isPair(list)) {
            result[i] = U.first(list);
            ++i;
            list = U.toList(list.rest);
        }
        return result;
    }

    public static Object listToArray(Class C, Object x) {
        Pair list = U.toList(x);
        int L = list.length();
        if (L == 0) {
            return Array.newInstance(C, 0);
        }
        Object result = Array.newInstance(C, L);
        int i = 0;
        while (U.isPair(list)) {
            Array.set(result, i, U.first(list));
            ++i;
            list = U.toList(list.rest);
        }
        return result;
    }

    public static Pair arrayToList(Object x) {
        Pair result = Pair.EMPTY;
        for (int i = Array.getLength(x) - 1; i >= 0; --i) {
            result = new Pair(Array.get(x, i), result);
        }
        return result;
    }

    public static Object apply(Procedure p, Pair args) {
        Pair next;
        Pair previous = null;
        Pair last = args;
        while (!(next = (Pair)last.getRest()).isEmpty()) {
            if (Scheme.isInterruptable()) {
                Scheme.interruptCheck();
            }
            previous = last;
            last = next;
        }
        if (previous == null) {
            args = (Pair)args.getFirst();
        } else {
            previous.rest = (Pair)last.first;
        }
        return p.apply(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

