/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import jsint.Closure;
import jsint.E;
import jsint.Import;
import jsint.Invoke;
import jsint.Pair;
import jsint.Procedure;
import jsint.StaticReflector;
import jsint.Symbol;
import jsint.U;

public class Generic
extends StaticReflector {
    private Object[] methodTable;

    public Object[] getMethodTable() {
        return this.methodTable;
    }

    public Generic(String name) {
        this.name = name;
    }

    private void addMethod(Class[] types, Procedure p) {
        if (this.methodTable == null) {
            this.methodTable = new Object[2];
            this.install(0, types, p);
        } else {
            for (int i = 0; i < this.methodTable.length; i += 2) {
                if (!Invoke.parameterTypesMatch((Class[])this.methodTable[i], types)) continue;
                this.install(i, types, p);
                return;
            }
            this.grow();
            this.install(this.methodTable.length - 2, types, p);
        }
    }

    private void install(int i, Class[] types, Procedure p) {
        this.methodTable[i] = types;
        this.methodTable[i + 1] = p;
    }

    private void grow() {
        Object[] ms = new Object[this.methodTable.length + 2];
        System.arraycopy(this.methodTable, 0, ms, 0, this.methodTable.length);
        this.methodTable = ms;
    }

    private static Generic ensureGeneric(Symbol name) {
        if (name.isDefined()) {
            Object v = name.getGlobalValue();
            if (!(v instanceof Generic)) {
                E.warn(name + " was bound to " + v + " it is now a Generic.");
                Generic g = new Generic(name.toString());
                name.setGlobalValue(g);
                return g;
            }
            return (Generic)v;
        }
        Generic g = new Generic(name.toString());
        name.setGlobalValue(g);
        return g;
    }

    public static synchronized Generic defineMethod(Symbol name, Pair types, Procedure p) {
        Generic g = Generic.ensureGeneric(name);
        g.addMethod(Invoke.toClassArray(types, 0), p);
        return g;
    }

    public Closure findMethod(Object[] args) {
        return (Closure)Invoke.findMethodNoOpt(this.methodTable, args);
    }

    public Object apply(Object[] args) {
        Procedure m = (Procedure)Invoke.findMethodNoOpt(this.methodTable, args);
        if (m.minArgs == 0 && m.maxArgs == Integer.MAX_VALUE) {
            return m.apply(new Object[]{U.vectorToList(args)});
        }
        return m.apply(args);
    }

    protected synchronized void reset() {
        for (int i = 0; i < this.methodTable.length; i += 2) {
            this.methodTable[i] = this.resetParameters((Class[])this.methodTable[i]);
        }
    }

    private Object[] resetParameters(Class[] parameters) {
        Object[] parameters2 = new Class[parameters.length];
        for (int i = 0; i < parameters2.length; ++i) {
            parameters2[i] = Import.forName(parameters[i].getName());
        }
        return parameters2;
    }
}

