/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import jsint.BacktraceException;
import jsint.Closure;
import jsint.ContinuationException;
import jsint.DynamicEnvironment;
import jsint.DynamicVariable;
import jsint.E;
import jsint.Generic;
import jsint.Import;
import jsint.InputPort;
import jsint.JschemeThrowable;
import jsint.LexicalEnvironment;
import jsint.LocalVariable;
import jsint.Macro;
import jsint.Pair;
import jsint.Primitive;
import jsint.Procedure;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class Evaluator
implements Serializable {
    private boolean exit = false;
    private transient InputPort input = new InputPort(System.in);
    private transient PrintWriter output = new PrintWriter(System.out, true);
    private transient PrintWriter error = new PrintWriter(System.err, true);
    public boolean INTERRUPTABLE = false;
    public DynamicEnvironment interactionEnvironment = null;
    public static DynamicEnvironment NULL_ENVIRONMENT = new DynamicEnvironment();
    public DynamicEnvironment INITIAL_ENVIRONMENT = null;
    private static HashMap environmentCache = new HashMap();
    private static DynamicEnvironment BASE_ENVIRONMENT = null;
    private boolean nameResults = true;

    public boolean setExit(boolean exit) {
        this.exit = exit;
        return this.exit;
    }

    public void setInput(InputPort ip) {
        this.input = ip;
    }

    public InputPort getInput() {
        return this.input;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter w) {
        this.output = w;
    }

    public PrintWriter getError() {
        return this.error;
    }

    public void setError(PrintWriter w) {
        this.error = w;
    }

    public void interrupt(Thread t) {
        this.INTERRUPTABLE = true;
        t.interrupt();
    }

    public void interruptCheck() {
        if (this.INTERRUPTABLE) {
            Thread.currentThread();
            if (Thread.interrupted()) {
                this.INTERRUPTABLE = false;
                throw new JschemeThrowable((Object)"Execution was interrupted.");
            }
        }
    }

    public DynamicEnvironment getInteractionEnvironment() {
        return this.interactionEnvironment;
    }

    public static DynamicEnvironment getNullEnvironment() {
        return NULL_ENVIRONMENT;
    }

    public DynamicEnvironment getInitialEnvironment() {
        return this.INITIAL_ENVIRONMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Evaluator() {
        Scheme.pushEvaluator(this);
        try {
            if (BASE_ENVIRONMENT == null) {
                this.interactionEnvironment = new DynamicEnvironment();
                Primitive.loadPrimitives();
                BASE_ENVIRONMENT = new DynamicEnvironment(this.interactionEnvironment);
                BASE_ENVIRONMENT.lockDown();
            } else {
                this.interactionEnvironment = new DynamicEnvironment(BASE_ENVIRONMENT);
            }
            this.INITIAL_ENVIRONMENT = new DynamicEnvironment(this.interactionEnvironment);
            this.INITIAL_ENVIRONMENT.lockDown();
        }
        finally {
            Scheme.popEvaluator();
        }
    }

    public Evaluator(DynamicEnvironment env) {
        this.interactionEnvironment = new DynamicEnvironment(env);
        this.INITIAL_ENVIRONMENT = new DynamicEnvironment(this.interactionEnvironment);
        this.INITIAL_ENVIRONMENT.lockDown();
    }

    public void runJscheme() {
        if (this.exit) {
            return;
        }
        this.showVersion();
        this.readEvalWriteLoop("> ");
    }

    public void enableNamedResults(boolean enabled) {
        this.nameResults = enabled;
    }

    public boolean readEvalWriteLoop(String prompt) {
        int count = 0;
        while (!this.exit) {
            try {
                this.output.print(prompt);
                this.output.flush();
                Object x = this.input.read();
                if (x == InputPort.EOF) {
                    return true;
                }
                Object result = this.eval(x);
                if (this.nameResults) {
                    String name = "$" + ++count;
                    this.output.print(name + " = ");
                    this.interactionEnvironment.setValue(Symbol.intern(name), result);
                }
                U.write(result, this.output, true);
                this.output.write("\n");
                this.output.println();
                this.output.flush();
            }
            catch (Throwable e) {
                e.printStackTrace(this.error);
                this.error.flush();
            }
        }
        return false;
    }

    public DynamicEnvironment loadEnvironment(Object x) {
        Object cacheKey = x;
        Object cached = environmentCache.get(cacheKey);
        try {
            if (x instanceof String) {
                cacheKey = new File((String)x).getCanonicalFile().toString().intern();
                cached = environmentCache.get(cacheKey);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cached != null) {
            return (DynamicEnvironment)cached;
        }
        Evaluator evaluator = new Evaluator();
        DynamicEnvironment env = evaluator.interactionEnvironment;
        Scheme.pushEvaluator(evaluator);
        evaluator.load(x);
        env = evaluator.interactionEnvironment;
        Scheme.popEvaluator();
        env.lockDown();
        environmentCache.put(cacheKey, env);
        return env;
    }

    public Boolean environmentImport(Object x, Object prefix) {
        return this.environmentImport(x, prefix, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean environmentImport(Object x, Object prefix, boolean macrosFlag, Symbol[] procnames) {
        DynamicEnvironment dynamicEnvironment = this.interactionEnvironment;
        synchronized (dynamicEnvironment) {
            DynamicEnvironment env = this.loadEnvironment(x);
            if (prefix instanceof String) {
                if (macrosFlag && ((String)prefix).length() > 0) {
                    E.error("(environment-import): macros cannot have a prefix" + prefix);
                    return Boolean.FALSE;
                }
                this.interactionEnvironment.importBindings(env, (String)prefix, macrosFlag, procnames);
                return Boolean.TRUE;
            }
            if (prefix == U.MISSING || prefix instanceof Boolean && (Boolean)prefix == Boolean.FALSE) {
                this.interactionEnvironment.importBindings(env, null, macrosFlag, procnames);
                return Boolean.TRUE;
            }
            E.error("(environment-import): prefix is not string or #f: " + prefix);
            return Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean languageImport(Object x) {
        DynamicEnvironment dynamicEnvironment = this.interactionEnvironment;
        synchronized (dynamicEnvironment) {
            DynamicEnvironment env = this.loadEnvironment(x);
            this.interactionEnvironment.importBindings(env, null, true);
            return Boolean.TRUE;
        }
    }

    public Object load(Object fileName) {
        String name = fileName.toString();
        InputPort iport = Scheme.open(name);
        if (iport == null) {
            return E.warn("(load) can't open \"" + fileName + "\"");
        }
        return this.load(iport);
    }

    public Object load(InputPort in) {
        while (!this.exit) {
            try {
                Object x = in.read();
                if (x == InputPort.EOF) {
                    return U.TRUE;
                }
                this.evalToplevel(x, this.interactionEnvironment);
            }
            catch (Exception e) {
                E.warn("Error during load (lineno " + in.getLineNumber() + "): ", e);
                e.printStackTrace(this.error);
            }
        }
        return U.FALSE;
    }

    public Object evalToplevel(Object x, DynamicEnvironment env) {
        if (U.isPair(x)) {
            Object mx = Macro.expand((Pair)x);
            if (x != mx) {
                return this.evalToplevel(mx, env);
            }
            if (U.first(x) == Symbol.BEGIN) {
                Object xs = U.rest(x);
                Object result = null;
                while (U.isPair(xs)) {
                    result = this.eval(U.first(xs), env);
                    xs = U.rest(xs);
                }
                return result;
            }
            return this.eval(x, env);
        }
        return this.eval(x, env);
    }

    public Object eval(Object x) {
        return this.eval(x, this.interactionEnvironment);
    }

    public Object eval(Object x, Object env) {
        DynamicEnvironment dynamicEnv = env == U.MISSING ? this.interactionEnvironment : (DynamicEnvironment)env;
        Object analyzedCode = this.analyze(x, dynamicEnv, LexicalEnvironment.NULLENV);
        return this.execute(analyzedCode, LexicalEnvironment.NULLENV);
    }

    public Object analyze(Object x, DynamicEnvironment dynamicEnv, LexicalEnvironment lexenv) {
        if (x instanceof Symbol) {
            LocalVariable localvar = lexenv.lookup((Symbol)x);
            if (localvar == null) {
                return dynamicEnv.intern((Symbol)x);
            }
            return localvar;
        }
        if (!U.isPair(x)) {
            return new Object[]{Symbol.QUOTE, x};
        }
        Object f = U.first(x);
        int len = ((Pair)x).length();
        if (Symbol.LAMBDA == f && len >= 3) {
            Object args = U.second(x);
            LexicalEnvironment lexenv2 = new LexicalEnvironment(args, null, lexenv);
            return new Closure(args, this.analyze(Scheme.toBody(U.rest(U.rest(x))), dynamicEnv, lexenv2), lexenv);
        }
        if (Symbol.MACRO == f && len >= 3) {
            Object args = U.second(x);
            LexicalEnvironment lexenv2 = new LexicalEnvironment(args, null, lexenv);
            return new Macro(args, this.analyze(Scheme.toBody(U.rest(U.rest(x))), dynamicEnv, lexenv2), lexenv);
        }
        if (2 == len && Symbol.BEGIN == f) {
            return this.analyze(U.second(x), dynamicEnv, lexenv);
        }
        Object xm = Macro.expand((Pair)x);
        if (x != xm) {
            return this.analyze(xm, dynamicEnv, lexenv);
        }
        if (Symbol.OR == f && len == 1) {
            return new Object[]{Symbol.QUOTE, U.FALSE};
        }
        if (Symbol.IF == f && len == 3) {
            return this.analyze(U.append(U.list(x, U.list(U.FALSE))), dynamicEnv, lexenv);
        }
        if (Symbol.QUOTE == f && len == 2) {
            return new Object[]{Symbol.QUOTE, U.second(x)};
        }
        Evaluator.checkLength(f, len, x);
        Object[] xv = U.listToVector(x);
        if (!Evaluator.isSpecial(f)) {
            xv[0] = this.analyze(xv[0], dynamicEnv, lexenv);
        }
        for (int i = 1; i < xv.length; ++i) {
            xv[i] = this.analyze(xv[i], dynamicEnv, lexenv);
        }
        return xv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object x, LexicalEnvironment lexenv) {
        while (true) {
            int xvlm1;
            if (!(x instanceof Object[])) {
                if (x instanceof DynamicVariable) {
                    return ((DynamicVariable)x).getDynamicValue();
                }
                if (x instanceof LocalVariable) {
                    return lexenv.get((LocalVariable)x);
                }
                return ((Closure)x).copy(lexenv);
            }
            Object[] xv = (Object[])x;
            Object f = xv[0];
            if (f == Symbol.QUOTE) {
                return xv[1];
            }
            if (f == Symbol.IF) {
                x = U.to_bool(this.execute(xv[1], lexenv)) ? xv[2] : xv[3];
                continue;
            }
            if (f == Symbol.BEGIN) {
                x = this.executeButLast(xv, lexenv);
                continue;
            }
            if (f == Symbol.OR) {
                xvlm1 = xv.length - 1;
            } else {
                if (f == Symbol.SET && xv[1] instanceof DynamicVariable) {
                    return ((DynamicVariable)xv[1]).setDynamicValue(this.execute(xv[2], lexenv));
                }
                if (f == Symbol.SET && xv[1] instanceof LocalVariable) {
                    return lexenv.set((LocalVariable)xv[1], this.execute(xv[2], lexenv));
                }
                if (this.INTERRUPTABLE) {
                    this.interruptCheck();
                }
                try {
                    f = this.executef(f, lexenv);
                    if (f instanceof Closure) {
                        Closure c = (Closure)f;
                        x = c.body;
                        lexenv = new LexicalEnvironment(c.parms, c.makeArgArray(xv, this, lexenv), c.lexenv);
                    }
                    if (!(f instanceof Generic)) {
                        Procedure p = U.toProc(f);
                        return p.apply(p.makeArgArray(xv, this, lexenv));
                    }
                    Generic g = (Generic)f;
                    Object[] args = g.makeArgArray(xv, this, lexenv);
                    Closure c = g.findMethod(args);
                    x = c.body;
                    lexenv = new LexicalEnvironment(c.parms, args, c.lexenv);
                }
                catch (ContinuationException ce) {
                    throw ce;
                }
                catch (RuntimeException e) {
                    if (e instanceof JschemeThrowable && e.getMessage() == null) {
                        throw e;
                    }
                    throw new BacktraceException(e, xv, lexenv);
                }
            }
            for (int i = 1; i < xvlm1; ++i) {
                Object result = this.execute(xv[i], lexenv);
                if (U.toBool(result) == U.FALSE) continue;
                return result;
            }
            x = xv[xvlm1];
        }
    }

    private Object executef(Object x, LexicalEnvironment lexenv) {
        if (x instanceof DynamicVariable) {
            return ((DynamicVariable)x).getDynamicValue();
        }
        if (x instanceof LocalVariable) {
            return lexenv.get((LocalVariable)x);
        }
        if (x instanceof Closure) {
            return ((Closure)x).copy(lexenv);
        }
        return this.execute(x, lexenv);
    }

    private static boolean isSpecial(Object f) {
        return f == Symbol.SET || f == Symbol.IF || f == Symbol.BEGIN || f == Symbol.OR || f == Symbol.QUOTE;
    }

    private static void checkLength(Object f, int len, Object x) {
        if (f == Symbol.LAMBDA && len < 3 || f == Symbol.MACRO && len < 3 || f == Symbol.SET && len != 3 || f == Symbol.IF && len != 4 || f == Symbol.BEGIN && len <= 2 || f == Symbol.OR && len < 2 || f == Symbol.QUOTE && len != 2) {
            E.warn("wrong number of arguments for syntax:", x);
        }
    }

    private Object executeButLast(Object[] xv, LexicalEnvironment lexenv) {
        for (int i = 1; i < xv.length - 1; ++i) {
            this.execute(xv[i], lexenv);
        }
        return xv[xv.length - 1];
    }

    private void showVersion() {
        this.error.println(this.getVersion());
    }

    private String getVersion() {
        InputStream stream;
        String defaultmsg = "Jscheme http://jscheme.sourceforge.net";
        String name = "jsint/version.txt";
        ClassLoader loader = Import.getClassLoader();
        InputStream inputStream = stream = loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
        if (stream == null) {
            return defaultmsg;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        try {
            return r.readLine();
        }
        catch (IOException e) {
            return defaultmsg;
        }
    }

    static {
        NULL_ENVIRONMENT.lockDown();
    }
}

