/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.PrintStream;
import java.io.PrintWriter;
import jscheme.JScheme;
import jsint.LexicalEnvironment;
import jsint.LocalVariable;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class BacktraceException
extends RuntimeException {
    public static boolean printJavaTrace = false;
    private Throwable exception;
    private Object[] args;
    private LexicalEnvironment lexenv;
    private static final Symbol backtraceBody = Symbol.intern("backtraceBody");
    private static boolean triedOnce = false;
    static /* synthetic */ Class class$jsint$LocalVariable;

    public BacktraceException(Throwable e, Object[] args) {
        this(e, args, LexicalEnvironment.NULLENV);
    }

    public BacktraceException(Throwable e, Object[] args, LexicalEnvironment lexenv) {
        super(e.getMessage());
        this.exception = e;
        this.args = args;
        this.lexenv = lexenv;
    }

    public Throwable fillInStackTrace() {
        return this;
    }

    public Throwable getBaseException() {
        Throwable t = this.exception;
        while (t instanceof BacktraceException) {
            t = ((BacktraceException)t).exception;
        }
        return t;
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace() {
        this.printStackTrace(Scheme.currentEvaluator().getError());
    }

    public static boolean checkBacktrace() {
        try {
            if (Scheme.currentEvaluator().getInteractionEnvironment().isDefined(backtraceBody)) {
                return true;
            }
            if (triedOnce) {
                return false;
            }
            triedOnce = true;
            Scheme.load("elf/basic.scm");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void printStackTrace(PrintWriter s) {
        try {
            if (BacktraceException.checkBacktrace()) {
                Object bbProc = Scheme.currentEvaluator().getInteractionEnvironment().getValue(backtraceBody);
                U.toProc(bbProc).apply(JScheme.list(this.lexenv, this.args));
            } else {
                s.print("showargs: ");
                this.showargs(this.args, s);
            }
            s.println();
            this.lexenv.show(s);
            s.println("\n  ====================================");
            if (printJavaTrace || this.exception instanceof BacktraceException) {
                this.exception.printStackTrace(s);
            } else {
                s.println(this.exception);
            }
            s.flush();
        }
        catch (Throwable e) {
            s.println("Error in BacktraceException.printStackTrace: ");
            try {
                BacktraceException.ultimateException(e).printStackTrace(s);
            }
            catch (Throwable e2) {
                try {
                    s.println("Error tracing the ultimate error: " + BacktraceException.ultimateException(e));
                }
                catch (Throwable e3) {
                    s.println("Error printing ultimate error of class: " + BacktraceException.ultimateException(e).getClass());
                }
            }
        }
    }

    public void showargs(Object x, PrintWriter s) {
        if (x == null) {
            s.println();
        } else if (x.getClass().isArray()) {
            Object[] xv = (Object[])x;
            if (xv.length > 0 && Symbol.QUOTE == xv[0]) {
                s.print(U.stringify(xv[1]) + " ");
            } else {
                s.print("(");
                for (int i = 0; i < xv.length; ++i) {
                    this.showargs(xv[i], s);
                }
                s.print(")");
            }
        } else if (x.getClass() == (class$jsint$LocalVariable == null ? (class$jsint$LocalVariable = BacktraceException.class$("jsint.LocalVariable")) : class$jsint$LocalVariable)) {
            s.print(((LocalVariable)x).name + " ");
        } else {
            s.print(U.stringify(x) + " ");
        }
    }

    private static Throwable ultimateException(Throwable e) {
        return e instanceof BacktraceException ? BacktraceException.ultimateException(((BacktraceException)e).exception) : e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

