/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.en.us;

import com.sun.speech.freetts.Age;
import com.sun.speech.freetts.Gender;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.en.us.CMUVoice;
import com.sun.speech.freetts.util.Utilities;
import de.dfki.lt.freetts.mbrola.MbrolaAudioOutput;
import de.dfki.lt.freetts.mbrola.MbrolaCaller;
import de.dfki.lt.freetts.mbrola.ParametersToMbrolaConverter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

public class MbrolaVoice
extends CMUVoice {
    private String databaseDirectory;
    private String database;
    private static final String MRPA_TO_SAMPA_RENAME_LIST = "V ah i iy I ih U uh { ae @ ax r= er A aa O ao u uw E eh EI ey AI ay OI oy aU aw @U ow j y h hh N ng S sh T th Z zh D dh tS ch dZ jh _ pau";

    public MbrolaVoice(String databaseDirectory, String database, float rate, float pitch, float range, String name, Gender gender, Age age, String description, Locale locale, String domain, String organization, CMULexicon lexicon) {
        super(name, gender, age, description, locale, domain, organization, lexicon);
        this.setRate(rate);
        this.setPitch(pitch);
        this.setPitchRange(range);
        this.databaseDirectory = databaseDirectory;
        this.database = database;
    }

    protected UtteranceProcessor getUnitSelector() throws IOException {
        return new ParametersToMbrolaConverter();
    }

    protected String[] getMbrolaCommand() {
        String[] cmd = new String[]{this.getMbrolaBinary(), "-e", "-R", this.getRenameList(), this.getDatabase(), "-", "-.raw"};
        return cmd;
    }

    public String getMbrolaBase() {
        return Utilities.getProperty((String)"mbrola.base", (String)".");
    }

    public String getMbrolaBinary() {
        StringBuffer executable = new StringBuffer();
        executable.append("mbrola");
        String os = System.getProperty("os.name");
        if (os.indexOf("Windows") >= 0) {
            executable.append(".exe");
        }
        return this.getMbrolaBase() + File.separator + executable.toString();
    }

    public String getRenameList() {
        return MRPA_TO_SAMPA_RENAME_LIST;
    }

    public String getDatabase() {
        return this.getMbrolaBase() + File.separator + this.databaseDirectory + File.separator + this.database;
    }

    protected UtteranceProcessor getUnitConcatenator() throws IOException {
        return new MbrolaCaller(this.getMbrolaCommand());
    }

    protected UtteranceProcessor getAudioOutput() throws IOException {
        return new MbrolaAudioOutput();
    }

    protected URL getResource(String resource) {
        return CMUVoice.class.getResource(resource);
    }

    public String toString() {
        return "MbrolaVoice";
    }
}

