/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.StringTokenizer;
import org.scilab.forge.jlatexmath.AccentedAtom;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigDelimiterAtom;
import org.scilab.forge.jlatexmath.BoldAtom;
import org.scilab.forge.jlatexmath.CedillaAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.DdotsAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.FBoxAtom;
import org.scilab.forge.jlatexmath.FencedAtom;
import org.scilab.forge.jlatexmath.FractionAtom;
import org.scilab.forge.jlatexmath.GeoGebraLogoAtom;
import org.scilab.forge.jlatexmath.GraphicsAtom;
import org.scilab.forge.jlatexmath.HdotsforAtom;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.IJAtom;
import org.scilab.forge.jlatexmath.IddotsAtom;
import org.scilab.forge.jlatexmath.ItAtom;
import org.scilab.forge.jlatexmath.LCaronAtom;
import org.scilab.forge.jlatexmath.LaTeXAtom;
import org.scilab.forge.jlatexmath.LapedAtom;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.MultlineAtom;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.NewEnvironmentMacro;
import org.scilab.forge.jlatexmath.NthRoot;
import org.scilab.forge.jlatexmath.OgonekAtom;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.OverlinedAtom;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.ReflectAtom;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RotateAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.RuleAtom;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SsAtom;
import org.scilab.forge.jlatexmath.StyleAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TStrokeAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TtAtom;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.UnderOverArrowAtom;
import org.scilab.forge.jlatexmath.UnderOverAtom;
import org.scilab.forge.jlatexmath.UnderlinedAtom;
import org.scilab.forge.jlatexmath.UnderscoreAtom;
import org.scilab.forge.jlatexmath.VRowAtom;
import org.scilab.forge.jlatexmath.VdotsAtom;
import org.scilab.forge.jlatexmath.XArrowAtom;
import org.scilab.forge.jlatexmath.dynamic.DynamicAtom;
import org.scilab.forge.jlatexmath.tcaronAtom;

public class predefMacros {
    public Atom Braket_macro(TeXParser tp, String[] args) throws ParseException {
        String str = args[1].replaceAll("\\|", "\\\\middle\\\\vert ");
        return new TeXFormula((String)new StringBuilder().append((String)"\\left\\langle ").append((String)str).append((String)"\\right\\rangle").toString()).root;
    }

    public Atom Set_macro(TeXParser tp, String[] args) throws ParseException {
        String str = args[1].replaceFirst("\\|", "\\\\middle\\\\vert ");
        return new TeXFormula((String)new StringBuilder().append((String)"\\left\\{").append((String)str).append((String)"\\right\\}").toString()).root;
    }

    public Atom spATbreve_macro(TeXParser tp, String[] args) throws ParseException {
        VRowAtom vra = new VRowAtom(new TeXFormula((String)"\\displaystyle\\!\\breve{}").root);
        vra.setRaise(1, 0.6f);
        return new SmashedAtom(vra, null);
    }

    public Atom spAThat_macro(TeXParser tp, String[] args) throws ParseException {
        VRowAtom vra = new VRowAtom(new TeXFormula((String)"\\displaystyle\\widehat{}").root);
        vra.setRaise(1, 0.6f);
        return new SmashedAtom(vra, null);
    }

    public Atom hvspace_macro(TeXParser tp, String[] args) throws ParseException {
        int i;
        for (i = 0; i < args[1].length() && !Character.isLetter(args[1].charAt(i)); ++i) {
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(args[1].substring(0, i));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.toString());
        }
        int unit = i != args[1].length() ? SpaceAtom.getUnit(args[1].substring(i).toLowerCase()) : 3;
        if (unit == -1) {
            throw new ParseException("Unknown unit \"" + args[1].substring(i) + "\" !");
        }
        return args[0].charAt(0) == 'h' ? new SpaceAtom(unit, f, 0.0f, 0.0f) : new SpaceAtom(unit, 0.0f, f, 0.0f);
    }

    public Atom clrlap_macro(TeXParser tp, String[] args) throws ParseException {
        return new LapedAtom(new TeXFormula((String)args[1]).root, args[0].charAt(0));
    }

    public Atom mathclrlap_macro(TeXParser tp, String[] args) throws ParseException {
        return new LapedAtom(new TeXFormula((String)args[1]).root, args[0].charAt(4));
    }

    public Atom includegraphics_macro(TeXParser tp, String[] args) throws ParseException {
        return new GraphicsAtom(args[1]);
    }

    public Atom rule_macro(TeXParser tp, String[] args) throws ParseException {
        float[] winfo = SpaceAtom.getLength(args[1]);
        if (winfo.length == 1) {
            throw new ParseException("Error in getting width in \\rule command !");
        }
        float[] hinfo = SpaceAtom.getLength(args[2]);
        if (hinfo.length == 1) {
            throw new ParseException("Error in getting height in \\rule command !");
        }
        float[] rinfo = SpaceAtom.getLength(args[3]);
        if (rinfo.length == 1) {
            throw new ParseException("Error in getting raise in \\rule command !");
        }
        return new RuleAtom((int)winfo[0], winfo[1], (int)hinfo[0], hinfo[1], (int)rinfo[0], -rinfo[1]);
    }

    public Atom cfrac_macro(TeXParser tp, String[] args) throws ParseException {
        int alig = 2;
        if ("r".equals(args[3])) {
            alig = 1;
        } else if ("l".equals(args[3])) {
            alig = 0;
        }
        TeXFormula num = new TeXFormula(args[1], false);
        TeXFormula denom = new TeXFormula(args[2], false);
        if (num.root == null || denom.root == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        FractionAtom f = new FractionAtom(num.root, denom.root, true, alig, 2);
        RowAtom rat = new RowAtom();
        rat.add(new StyleAtom(0, f));
        return rat;
    }

    public Atom frac_macro(TeXParser tp, String[] args) throws ParseException {
        TeXFormula num = new TeXFormula(args[1], false);
        TeXFormula denom = new TeXFormula(args[2], false);
        if (num.root == null || denom.root == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(num.root, denom.root, true);
    }

    public Atom genfrac_macro(TeXParser tp, String[] args) throws ParseException {
        TeXFormula right;
        TeXFormula left = new TeXFormula(args[1], false);
        SymbolAtom L = null;
        SymbolAtom R = null;
        if (left != null && left.root instanceof SymbolAtom) {
            L = (SymbolAtom)left.root;
        }
        if ((right = new TeXFormula(args[2], false)) != null && right.root instanceof SymbolAtom) {
            R = (SymbolAtom)right.root;
        }
        boolean rule = true;
        float[] ths = SpaceAtom.getLength(args[3]);
        if (args[3] == null || args[3].length() == 0 || ths.length == 1) {
            ths = new float[]{0.0f, 0.0f};
            rule = false;
        }
        int style = 0;
        if (args[4].length() != 0) {
            style = Integer.parseInt(args[4]);
        }
        TeXFormula num = new TeXFormula(args[5], false);
        TeXFormula denom = new TeXFormula(args[6], false);
        if (num.root == null || denom.root == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        FractionAtom at = new FractionAtom(num.root, denom.root, rule, (int)ths[0], ths[1]);
        RowAtom rat = new RowAtom();
        rat.add(new StyleAtom(style * 2, new FencedAtom(at, L, R)));
        return rat;
    }

    public Atom over_macro(TeXParser tp, String[] args) throws ParseException {
        Atom num = tp.getFormulaAtom();
        Atom denom = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        if (num == null || denom == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(num, denom, true);
    }

    public Atom overwithdelims_macro(TeXParser tp, String[] args) throws ParseException {
        Atom right;
        Atom num = tp.getFormulaAtom();
        Atom denom = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        if (num == null || denom == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        Atom left = new TeXFormula((String)args[1], (boolean)false).root;
        if (left instanceof BigDelimiterAtom) {
            left = ((BigDelimiterAtom)left).delim;
        }
        if ((right = new TeXFormula((String)args[2], (boolean)false).root) instanceof BigDelimiterAtom) {
            right = ((BigDelimiterAtom)right).delim;
        }
        if (left instanceof SymbolAtom && right instanceof SymbolAtom) {
            return new FencedAtom(new FractionAtom(num, denom, true), (SymbolAtom)left, (SymbolAtom)right);
        }
        RowAtom ra = new RowAtom();
        ra.add(left);
        ra.add(new FractionAtom(num, denom, true));
        ra.add(right);
        return ra;
    }

    public Atom atop_macro(TeXParser tp, String[] args) throws ParseException {
        Atom num = tp.getFormulaAtom();
        Atom denom = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        if (num == null || denom == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(num, denom, false);
    }

    public Atom atopwithdelims_macro(TeXParser tp, String[] args) throws ParseException {
        Atom right;
        Atom num = tp.getFormulaAtom();
        Atom denom = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        if (num == null || denom == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        Atom left = new TeXFormula((String)args[1], (boolean)false).root;
        if (left instanceof BigDelimiterAtom) {
            left = ((BigDelimiterAtom)left).delim;
        }
        if ((right = new TeXFormula((String)args[2], (boolean)false).root) instanceof BigDelimiterAtom) {
            right = ((BigDelimiterAtom)right).delim;
        }
        if (left instanceof SymbolAtom && right instanceof SymbolAtom) {
            return new FencedAtom(new FractionAtom(num, denom, false), (SymbolAtom)left, (SymbolAtom)right);
        }
        RowAtom ra = new RowAtom();
        ra.add(left);
        ra.add(new FractionAtom(num, denom, false));
        ra.add(right);
        return ra;
    }

    public Atom choose_macro(TeXParser tp, String[] args) throws ParseException {
        Atom num = tp.getFormulaAtom();
        Atom denom = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        if (num == null || denom == null) {
            throw new ParseException("Both numerator and denominator of choose can't be empty!");
        }
        return new FencedAtom(new FractionAtom(num, denom, false), new SymbolAtom("lbrack", 4, true), new SymbolAtom("rbrack", 5, true));
    }

    public Atom binom_macro(TeXParser tp, String[] args) throws ParseException {
        TeXFormula num = new TeXFormula(args[1], false);
        TeXFormula denom = new TeXFormula(args[2], false);
        if (num.root == null || denom.root == null) {
            throw new ParseException("Both binomial coefficients must be not empty !!");
        }
        return new FencedAtom(new FractionAtom(num.root, denom.root, false), new SymbolAtom("lbrack", 4, true), new SymbolAtom("rbrack", 5, true));
    }

    public Atom textstyle_macros(TeXParser tp, String[] args) throws ParseException {
        if ("frak".equals(args[0])) {
            args[0] = "mathfrak";
        } else if ("Bbb".equals(args[0])) {
            args[0] = "mathbb";
        } else if ("bold".equals(args[0])) {
            return new BoldAtom(new TeXFormula((String)args[1], (boolean)false).root);
        }
        return new TeXFormula((String)args[1], (String)args[0]).root;
    }

    public Atom mbox_macro(TeXParser tp, String[] args) throws ParseException {
        String str = args[1].replaceAll("\\^\\{\\\\prime\\}", "'");
        str = str.replaceAll("\\^\\{\\\\prime\\\\prime\\}", "''");
        str = str.replaceAll("_", "\\\\_");
        RomanAtom group = new RomanAtom(new TeXFormula((String)str, (String)"mathnormal", (boolean)false, (boolean)false).root);
        return new StyleAtom(2, group);
    }

    public Atom text_macro(TeXParser tp, String[] args) throws ParseException {
        String str = args[1].replaceAll("\\^\\{\\\\prime\\}", "'");
        str = str.replaceAll("\\^\\{\\\\prime\\\\prime\\}", "''");
        str = str.replaceAll("_", "\\\\_");
        return new RomanAtom(new TeXFormula((String)str, (String)"mathnormal", (boolean)false, (boolean)false).root);
    }

    public Atom underscore_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderscoreAtom();
    }

    public Atom accent_macros(TeXParser tp, String[] args) throws ParseException {
        return new AccentedAtom(new TeXFormula((String)args[1], (boolean)false).root, args[0]);
    }

    public Atom grkaccent_macro(TeXParser tp, String[] args) throws ParseException {
        return new AccentedAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root, false);
    }

    public Atom accent_macro(TeXParser tp, String[] args) throws ParseException {
        return new AccentedAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom accentbis_macros(TeXParser tp, String[] args) throws ParseException {
        String acc = "";
        switch (args[0].charAt(0)) {
            case '~': {
                acc = "tilde";
                break;
            }
            case '\'': {
                acc = "acute";
                break;
            }
            case '^': {
                acc = "hat";
                break;
            }
            case '\"': {
                acc = "ddot";
                break;
            }
            case '`': {
                acc = "grave";
                break;
            }
            case '=': {
                acc = "bar";
                break;
            }
            case '.': {
                acc = "dot";
                break;
            }
            case 'u': {
                acc = "breve";
                break;
            }
            case 'v': {
                acc = "check";
                break;
            }
            case 'H': {
                acc = "doubleacute";
                break;
            }
            case 't': {
                acc = "tie";
                break;
            }
            case 'r': {
                acc = "mathring";
                break;
            }
            case 'U': {
                acc = "cyrbreve";
            }
        }
        return new AccentedAtom(new TeXFormula((String)args[1], (boolean)false).root, acc);
    }

    public Atom cedilla_macro(TeXParser tp, String[] args) throws ParseException {
        return new CedillaAtom(new TeXFormula((String)args[1]).root);
    }

    public Atom IJ_macro(TeXParser tp, String[] args) throws ParseException {
        return new IJAtom(args[0].charAt(0) == 'I');
    }

    public Atom TStroke_macro(TeXParser tp, String[] args) throws ParseException {
        return new TStrokeAtom(args[0].charAt(0) == 'T');
    }

    public Atom LCaron_macro(TeXParser tp, String[] args) throws ParseException {
        return new LCaronAtom(args[0].charAt(0) == 'L');
    }

    public Atom tcaron_macro(TeXParser tp, String[] args) throws ParseException {
        return new tcaronAtom();
    }

    public Atom ogonek_macro(TeXParser tp, String[] args) throws ParseException {
        return new OgonekAtom(new TeXFormula((String)args[1]).root);
    }

    public Atom nbsp_macro(TeXParser tp, String[] args) throws ParseException {
        return new SpaceAtom();
    }

    public Atom sqrt_macro(TeXParser tp, String[] args) throws ParseException {
        if (args[2] == null) {
            return new NthRoot(new TeXFormula((String)args[1], (boolean)false).root, null);
        }
        return new NthRoot(new TeXFormula((String)args[1], (boolean)false).root, new TeXFormula((String)args[2], (boolean)false).root);
    }

    public Atom overrightarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, false, true);
    }

    public Atom overleftarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, true, true);
    }

    public Atom overleftrightarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, true);
    }

    public Atom underrightarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, false, false);
    }

    public Atom underleftarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, true, false);
    }

    public Atom underleftrightarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, false);
    }

    public Atom xleftarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new XArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, new TeXFormula((String)args[2]).root, true);
    }

    public Atom xrightarrow_macro(TeXParser tp, String[] args) throws ParseException {
        return new XArrowAtom(new TeXFormula((String)args[1], (boolean)false).root, new TeXFormula((String)args[2]).root, false);
    }

    public Atom sideset_macro(TeXParser tp, String[] args) throws ParseException {
        TeXFormula tf = new TeXFormula();
        tf.add(new PhantomAtom(new TeXFormula((String)args[3]).root, false, true, true));
        tf.append(args[1]);
        tf.add(new SpaceAtom(5, -0.3f, 0.0f, 0.0f));
        tf.append(args[3] + "\\nolimits" + args[2]);
        return new TypedAtom(0, 0, tf.root);
    }

    public Atom prescript_macro(TeXParser tp, String[] args) throws ParseException {
        Atom base = new TeXFormula((String)args[3]).root;
        tp.addAtom(new ScriptsAtom(new PhantomAtom(base, false, true, true), new TeXFormula((String)args[2]).root, new TeXFormula((String)args[1]).root, false));
        tp.addAtom(new SpaceAtom(5, -0.3f, 0.0f, 0.0f));
        return new TypedAtom(0, 0, base);
    }

    public Atom underbrace_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("rbrace"), 1, 0.0f, false);
    }

    public Atom overbrace_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("lbrace"), 1, 0.0f, true);
    }

    public Atom underbrack_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("rsqbrack"), 1, 0.0f, false);
    }

    public Atom overbrack_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("lsqbrack"), 1, 0.0f, true);
    }

    public Atom underparen_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("rbrack"), 1, 0.0f, false);
    }

    public Atom overparen_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverUnderDelimiter(new TeXFormula((String)args[1], (boolean)false).root, null, SymbolAtom.get("lbrack"), 1, 0.0f, true);
    }

    public Atom overline_macro(TeXParser tp, String[] args) throws ParseException {
        return new OverlinedAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom underline_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderlinedAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathop_macro(TeXParser tp, String[] args) throws ParseException {
        TypedAtom at = new TypedAtom(1, 1, new TeXFormula((String)args[1], (boolean)false).root);
        at.type_limits = 0;
        return at;
    }

    public Atom mathord_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(0, 0, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathrel_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(3, 3, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathinner_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(7, 7, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathbin_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(2, 2, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathopen_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(4, 4, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathclose_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(5, 5, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom joinrel_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(3, 3, new SpaceAtom(5, -2.6f, 0.0f, 0.0f));
    }

    public Atom smash_macro(TeXParser tp, String[] args) throws ParseException {
        return new SmashedAtom(new TeXFormula((String)args[1], (boolean)false).root, args[2]);
    }

    public Atom vdots_macro(TeXParser tp, String[] args) throws ParseException {
        return new VdotsAtom();
    }

    public Atom ddots_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(7, 7, new DdotsAtom());
    }

    public Atom iddots_macro(TeXParser tp, String[] args) throws ParseException {
        return new TypedAtom(7, 7, new IddotsAtom());
    }

    public Atom nolimits_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = tp.getLastAtom();
        at.type_limits = 1;
        return at.clone();
    }

    public Atom limits_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = tp.getLastAtom();
        at.type_limits = 2;
        return at.clone();
    }

    public Atom normal_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = tp.getLastAtom();
        at.type_limits = 0;
        return at.clone();
    }

    public Atom left_macro(TeXParser tp, String[] args) throws ParseException {
        Atom right;
        String grp = tp.getGroup("\\left", "\\right");
        Atom left = new TeXFormula((String)args[1], (boolean)false).root;
        if (left instanceof BigDelimiterAtom) {
            left = ((BigDelimiterAtom)left).delim;
        }
        if ((right = tp.getArgument()) instanceof BigDelimiterAtom) {
            right = ((BigDelimiterAtom)right).delim;
        }
        if (left instanceof SymbolAtom && right instanceof SymbolAtom) {
            TeXFormula tf = new TeXFormula(grp, false);
            return new FencedAtom(tf.root, (SymbolAtom)left, tf.middle, (SymbolAtom)right);
        }
        RowAtom ra = new RowAtom();
        ra.add(left);
        ra.add(new TeXFormula((String)grp, (boolean)false).root);
        ra.add(right);
        return ra;
    }

    public Atom middle_macro(TeXParser tp, String[] args) throws ParseException {
        return new MiddleAtom(new TeXFormula((String)args[1]).root);
    }

    public Atom cr_macro(TeXParser tp, String[] args) throws ParseException {
        if (!tp.isArrayMode()) {
            throw new ParseException("The token \\cr is only available in array mode !");
        }
        tp.addRow();
        return null;
    }

    public Atom backslashcr_macro(TeXParser tp, String[] args) throws ParseException {
        if (tp.isArrayMode()) {
            tp.addRow();
        }
        return null;
    }

    public Atom intertext_macro(TeXParser tp, String[] args) throws ParseException {
        if (!tp.isArrayMode()) {
            throw new ParseException("Bad environment for \\intertext command !");
        }
        String str = args[1].replaceAll("\\^\\{\\\\prime\\}", "'");
        str = str.replaceAll("\\^\\{\\\\prime\\\\prime\\}", "''");
        RomanAtom at = new RomanAtom(new TeXFormula((String)str, (String)"mathnormal", (boolean)false, (boolean)false).root);
        at.type = 11;
        tp.addAtom(at);
        tp.addRow();
        return null;
    }

    public Atom smallmatrixATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, 5);
    }

    public Atom matrixATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, 1);
    }

    public Atom multicolumn_macro(TeXParser tp, String[] args) throws ParseException {
        int n = Integer.parseInt(args[1]);
        tp.addAtom(new MulticolumnAtom(n, args[2], new TeXFormula((String)args[3]).root));
        ((ArrayOfAtoms)tp.formula).addCol(n);
        return null;
    }

    public Atom hdotsfor_macro(TeXParser tp, String[] args) throws ParseException {
        int n = Integer.parseInt(args[1]);
        float f = 1.0f;
        if (args[2] != null) {
            f = Float.parseFloat(args[2]);
        }
        tp.addAtom(new HdotsforAtom(n, f));
        ((ArrayOfAtoms)tp.formula).addCol(n);
        return null;
    }

    public Atom arrayATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[2], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, args[1]);
    }

    public Atom alignATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, 2);
    }

    public Atom flalignATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, 4);
    }

    public Atom alignatATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[2], array, false);
        parser.parse();
        array.checkDimensions();
        int n = Integer.parseInt(args[1]);
        if (array.col != 2 * n) {
            throw new ParseException("Bad number of equations in alignat environment !");
        }
        return new MatrixAtom(array, 3);
    }

    public Atom alignedATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        return new MatrixAtom(array, 6);
    }

    public Atom alignedatATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[2], array, false);
        parser.parse();
        array.checkDimensions();
        int n = Integer.parseInt(args[1]);
        if (array.col != 2 * n) {
            throw new ParseException("Bad number of equations in alignedat environment !");
        }
        return new MatrixAtom(array, 7);
    }

    public Atom multlineATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        if (array.col > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (array.col == 0) {
            return null;
        }
        return new MultlineAtom(array, 0);
    }

    public Atom gatherATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        if (array.col > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (array.col == 0) {
            return null;
        }
        return new MultlineAtom(array, 1);
    }

    public Atom gatheredATATenv_macro(TeXParser tp, String[] args) throws ParseException {
        ArrayOfAtoms array = new ArrayOfAtoms();
        TeXParser parser = new TeXParser(args[1], array, false);
        parser.parse();
        array.checkDimensions();
        if (array.col > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (array.col == 0) {
            return null;
        }
        return new MultlineAtom(array, 2);
    }

    public Atom shoveright_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = new TeXFormula((String)args[1]).root;
        at.alignment = 1;
        return at;
    }

    public Atom shoveleft_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = new TeXFormula((String)args[1]).root;
        at.alignment = 0;
        return at;
    }

    public Atom newcommand_macro(TeXParser tp, String[] args) throws ParseException {
        String newcom = args[1];
        if (!tp.isValidName(newcom)) {
            throw new ParseException("Invalid name for the command :" + newcom);
        }
        Integer nbArgs = args[3] == null ? new Integer(0) : Integer.valueOf(Integer.parseInt(args[3]));
        if (nbArgs == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        if (args[4] == null) {
            NewCommandMacro.addNewCommand(newcom.substring(1), args[2], nbArgs);
        } else {
            NewCommandMacro.addNewCommand(newcom.substring(1), args[2], nbArgs, args[4]);
        }
        return null;
    }

    public Atom renewcommand_macro(TeXParser tp, String[] args) throws ParseException {
        String newcom = args[1];
        if (!tp.isValidName(newcom)) {
            throw new ParseException("Invalid name for the command :" + newcom);
        }
        Integer nbArgs = args[3] == null ? new Integer(0) : Integer.valueOf(Integer.parseInt(args[3]));
        if (nbArgs == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewCommandMacro.addReNewCommand(newcom.substring(1), args[2], nbArgs);
        return null;
    }

    public Atom makeatletter_macro(TeXParser tp, String[] args) throws ParseException {
        tp.makeAtLetter();
        return null;
    }

    public Atom makeatother_macro(TeXParser tp, String[] args) throws ParseException {
        tp.makeAtOther();
        return null;
    }

    public Atom newenvironment_macro(TeXParser tp, String[] args) throws ParseException {
        Integer opt = args[4] == null ? 0 : Integer.parseInt(args[4]);
        if (opt == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewEnvironmentMacro.addNewEnvironment(args[1], args[2], args[3], opt);
        return null;
    }

    public Atom renewenvironment_macro(TeXParser tp, String[] args) throws ParseException {
        Integer opt = args[4] == null ? 0 : Integer.parseInt(args[4]);
        if (opt == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewEnvironmentMacro.addReNewEnvironment(args[1], args[2], args[3], opt);
        return null;
    }

    public Atom fbox_macro(TeXParser tp, String[] args) throws ParseException {
        return new FBoxAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom stackrel_macro(TeXParser tp, String[] args) throws ParseException {
        UnderOverAtom at = new UnderOverAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[3], (boolean)false).root, 5, 0.5f, true, new TeXFormula((String)args[1], (boolean)false).root, 5, 2.5f, true);
        return new TypedAtom(3, 3, at);
    }

    public Atom stackbin_macro(TeXParser tp, String[] args) throws ParseException {
        UnderOverAtom at = new UnderOverAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[3], (boolean)false).root, 5, 0.5f, true, new TeXFormula((String)args[1], (boolean)false).root, 5, 2.5f, true);
        return new TypedAtom(2, 2, at);
    }

    public Atom overset_macro(TeXParser tp, String[] args) throws ParseException {
        UnderOverAtom at = new UnderOverAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root, 5, 2.5f, true, true);
        return new TypedAtom(3, 3, at);
    }

    public Atom underset_macro(TeXParser tp, String[] args) throws ParseException {
        UnderOverAtom at = new UnderOverAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root, 5, 0.5f, true, false);
        return new TypedAtom(3, 3, at);
    }

    public Atom accentset_macro(TeXParser tp, String[] args) throws ParseException {
        return new AccentedAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom underaccent_macro(TeXParser tp, String[] args) throws ParseException {
        return new UnderOverAtom(new TeXFormula((String)args[2], (boolean)false).root, new TeXFormula((String)args[1], (boolean)false).root, 5, 0.3f, true, false);
    }

    public Atom undertilde_macro(TeXParser tp, String[] args) throws ParseException {
        Atom at = new TeXFormula((String)args[1], (boolean)false).root;
        return new UnderOverAtom(at, new AccentedAtom((Atom)new PhantomAtom(at, true, false, false), "widetilde"), 5, 0.3f, true, false);
    }

    public Atom boldsymbol_macro(TeXParser tp, String[] args) throws ParseException {
        return new BoldAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathrm_macro(TeXParser tp, String[] args) throws ParseException {
        return new RomanAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathbf_macro(TeXParser tp, String[] args) throws ParseException {
        return new BoldAtom(new RomanAtom(new TeXFormula((String)args[1], (boolean)false).root));
    }

    public Atom mathtt_macro(TeXParser tp, String[] args) throws ParseException {
        return new TtAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathit_macro(TeXParser tp, String[] args) throws ParseException {
        return new ItAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom mathsf_macro(TeXParser tp, String[] args) throws ParseException {
        return new SsAtom(new TeXFormula((String)args[1], (boolean)false).root);
    }

    public Atom LaTeX_macro(TeXParser tp, String[] args) throws ParseException {
        return new LaTeXAtom();
    }

    public Atom GeoGebra_macro(TeXParser tp, String[] args) throws ParseException {
        TeXFormula tf = new TeXFormula("\\mathbb{G}\\mathsf{e}");
        tf.add(new GeoGebraLogoAtom());
        tf.add("\\mathsf{Gebra}");
        return new ColorAtom(tf.root, null, new Color(102, 102, 102));
    }

    public Atom hphantom_macro(TeXParser tp, String[] args) throws ParseException {
        return new PhantomAtom(new TeXFormula((String)args[1], (boolean)false).root, true, false, false);
    }

    public Atom vphantom_macro(TeXParser tp, String[] args) throws ParseException {
        return new PhantomAtom(new TeXFormula((String)args[1], (boolean)false).root, false, true, true);
    }

    public Atom phantom_macro(TeXParser tp, String[] args) throws ParseException {
        return new PhantomAtom(new TeXFormula((String)args[1], (boolean)false).root, true, true, true);
    }

    public Atom big_macro(TeXParser tp, String[] args) throws ParseException {
        return new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 1);
    }

    public Atom Big_macro(TeXParser tp, String[] args) throws ParseException {
        return new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 2);
    }

    public Atom bigg_macro(TeXParser tp, String[] args) throws ParseException {
        return new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 3);
    }

    public Atom Bigg_macro(TeXParser tp, String[] args) throws ParseException {
        return new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 4);
    }

    public Atom bigl_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 1);
        at.type = 4;
        return at;
    }

    public Atom Bigl_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 2);
        at.type = 4;
        return at;
    }

    public Atom biggl_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 3);
        at.type = 4;
        return at;
    }

    public Atom Biggl_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 4);
        at.type = 4;
        return at;
    }

    public Atom bigr_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 1);
        at.type = 5;
        return at;
    }

    public Atom Bigr_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 2);
        at.type = 5;
        return at;
    }

    public Atom biggr_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 3);
        at.type = 5;
        return at;
    }

    public Atom Biggr_macro(TeXParser tp, String[] args) throws ParseException {
        BigDelimiterAtom at = new BigDelimiterAtom((SymbolAtom)new TeXFormula((String)args[1], (boolean)false).root, 4);
        at.type = 5;
        return at;
    }

    public Atom displaystyle_macro(TeXParser tp, String[] args) throws ParseException {
        Atom group = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        return new StyleAtom(0, group);
    }

    public Atom scriptstyle_macro(TeXParser tp, String[] args) throws ParseException {
        Atom group = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        return new StyleAtom(4, group);
    }

    public Atom textstyle_macro(TeXParser tp, String[] args) throws ParseException {
        Atom group = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        return new StyleAtom(2, group);
    }

    public Atom scriptscriptstyle_macro(TeXParser tp, String[] args) throws ParseException {
        Atom group = new TeXFormula((String)tp.getOverArgument(), (boolean)false).root;
        return new StyleAtom(6, group);
    }

    public Atom rotatebox_macro(TeXParser tp, String[] args) throws ParseException {
        return new RotateAtom(new TeXFormula((String)args[2]).root, args[1] == null ? 0.0 : Double.parseDouble(args[1]));
    }

    public Atom reflectbox_macro(TeXParser tp, String[] args) throws ParseException {
        return new ReflectAtom(new TeXFormula((String)args[1]).root);
    }

    public Atom scalebox_macro(TeXParser tp, String[] args) throws ParseException {
        return new ScaleAtom(new TeXFormula((String)args[2]).root, Double.parseDouble(args[1]), args[3] == null ? Double.parseDouble(args[1]) : Double.parseDouble(args[3]));
    }

    public Atom definecolor_macro(TeXParser tp, String[] args) throws ParseException {
        Color color = null;
        if ("gray".equals(args[2])) {
            float f = Float.parseFloat(args[3]);
            color = new Color(f, f, f);
        } else if ("rgb".equals(args[2])) {
            StringTokenizer stok = new StringTokenizer(args[3], ",");
            if (stok.countTokens() != 3) {
                throw new ParseException("The color definition must have three components !");
            }
            float r = Float.parseFloat(stok.nextToken());
            float g = Float.parseFloat(stok.nextToken());
            float b = Float.parseFloat(stok.nextToken());
            color = new Color(r, g, b);
        } else if ("cmyk".equals(args[2])) {
            StringTokenizer stok = new StringTokenizer(args[3], ",");
            if (stok.countTokens() != 4) {
                throw new ParseException("The color definition must have four components !");
            }
            float[] cmyk = new float[4];
            for (int i = 0; i < 4; ++i) {
                cmyk[i] = Float.parseFloat(stok.nextToken());
            }
            float k = 1.0f - cmyk[3];
            color = new Color(k * (1.0f - cmyk[0]), k * (1.0f - cmyk[1]), k * (1.0f - cmyk[2]));
        } else {
            throw new ParseException("The color model is incorrect !");
        }
        ColorAtom.Colors.put(args[1], color);
        return null;
    }

    public Atom fgcolor_macro(TeXParser tp, String[] args) throws ParseException {
        try {
            return new ColorAtom(new TeXFormula((String)args[2]).root, null, Color.decode("#" + args[1]));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.toString());
        }
    }

    public Atom bgcolor_macro(TeXParser tp, String[] args) throws ParseException {
        try {
            return new ColorAtom(new TeXFormula((String)args[2]).root, Color.decode("#" + args[1]), null);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.toString());
        }
    }

    public Atom textcolor_macro(TeXParser tp, String[] args) throws ParseException {
        return new ColorAtom(new TeXFormula((String)args[2]).root, null, ColorAtom.Colors.get(args[1]));
    }

    public Atom colorbox_macro(TeXParser tp, String[] args) throws ParseException {
        Color c = ColorAtom.Colors.get(args[1]);
        return new FBoxAtom(new TeXFormula((String)args[2]).root, c, c);
    }

    public Atom fcolorbox_macro(TeXParser tp, String[] args) throws ParseException {
        return new FBoxAtom(new TeXFormula((String)args[3]).root, ColorAtom.Colors.get(args[2]), ColorAtom.Colors.get(args[1]));
    }

    public Atom cong_macro(TeXParser tp, String[] args) throws ParseException {
        VRowAtom vra = new VRowAtom(new TeXFormula((String)"\\equals").root);
        vra.add(new SpaceAtom(5, 0.0f, 1.5f, 0.0f));
        vra.add(new TeXFormula((String)"\\sim").root);
        vra.setRaise(5, -1.0f);
        return new TypedAtom(3, 3, vra);
    }

    public Atom doteq_macro(TeXParser tp, String[] args) throws ParseException {
        UnderOverAtom at = new UnderOverAtom(new TeXFormula((String)"\\equals", (boolean)false).root, new TeXFormula((String)"\\ldotp", (boolean)false).root, 5, 3.7f, false, true);
        return new TypedAtom(3, 3, at);
    }

    public Atom jlmDynamic_macro(TeXParser tp, String[] args) throws ParseException {
        if (DynamicAtom.hasAnExternalConverterFactory()) {
            return new DynamicAtom(args[1]);
        }
        throw new ParseException("No ExternalConverterFactory set !");
    }

    public Atom DeclareMathSizes_macro(TeXParser tp, String[] args) throws ParseException {
        DefaultTeXFont.setMathSizes(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]));
        return null;
    }

    public Atom magnification_macro(TeXParser tp, String[] args) throws ParseException {
        DefaultTeXFont.setMagnification(Float.parseFloat(args[1]));
        return null;
    }

    public Atom hline_macro(TeXParser tp, String[] args) throws ParseException {
        if (!tp.isArrayMode()) {
            throw new ParseException("The macro \\hline is only available in array mode !");
        }
        return new HlineAtom();
    }

    public Atom size_macros(TeXParser tp, String[] args) throws ParseException {
        double f = 1.0;
        if ("tiny".equals(args[0])) {
            f = 0.5;
        } else if ("scriptsize".equals(args[0])) {
            f = 0.7;
        } else if ("footnotesize".equals(args[0])) {
            f = 0.8;
        } else if ("small".equals(args[0])) {
            f = 0.9;
        } else if ("normalsize".equals(args[0])) {
            f = 1.0;
        } else if ("large".equals(args[0])) {
            f = 1.2;
        } else if ("Large".equals(args[0])) {
            f = 1.4;
        } else if ("LARGE".equals(args[0])) {
            f = 1.8;
        } else if ("huge".equals(args[0])) {
            f = 2.0;
        } else if ("Huge".equals(args[0])) {
            f = 2.5;
        }
        return new ScaleAtom(new TeXFormula((String)tp.getOverArgument(), (boolean)false).root, f, f);
    }

    static {
        NewEnvironmentMacro.addNewEnvironment("array", "\\array@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("tabular", "\\array@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("matrix", "\\matrix@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("smallmatrix", "\\smallmatrix@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("pmatrix", "\\left(\\begin{matrix}", "\\end{matrix}\\right)", 0);
        NewEnvironmentMacro.addNewEnvironment("bmatrix", "\\left[\\begin{matrix}", "\\end{matrix}\\right]", 0);
        NewEnvironmentMacro.addNewEnvironment("Bmatrix", "\\left\\{\\begin{matrix}", "\\end{matrix}\\right\\}", 0);
        NewEnvironmentMacro.addNewEnvironment("vmatrix", "\\left|\\begin{matrix}", "\\end{matrix}\\right|", 0);
        NewEnvironmentMacro.addNewEnvironment("Vmatrix", "\\left\\|\\begin{matrix}", "\\end{matrix}\\right\\|", 0);
        NewEnvironmentMacro.addNewEnvironment("eqnarray", "\\begin{array}{rcl}", "\\end{array}", 0);
        NewEnvironmentMacro.addNewEnvironment("align", "\\align@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("flalign", "\\flalign@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("alignat", "\\alignat@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("aligned", "\\aligned@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("alignedat", "\\alignedat@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("multline", "\\multline@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("cases", "\\left\\{\\begin{array}{l@{\\!}l}", "\\end{array}\\right.", 0);
        NewEnvironmentMacro.addNewEnvironment("split", "\\begin{array}{rl}", "\\end{array}", 0);
        NewEnvironmentMacro.addNewEnvironment("gather", "\\gather@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("gathered", "\\gathered@@env{", "}", 0);
        NewCommandMacro.addNewCommand("operatorname", "\\mathop{\\mathrm{#1}}\\nolimits ", 1);
        NewCommandMacro.addNewCommand("DeclareMathOperator", "\\newcommand{#1}{\\mathop{\\mathrm{#2}}\\nolimits}", 2);
        NewCommandMacro.addNewCommand("substack", "{\\scriptstyle\\begin{array}{c}#1\\end{array}}", 1);
        NewCommandMacro.addNewCommand("dfrac", "\\genfrac{}{}{}{}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("tfrac", "\\genfrac{}{}{}{1}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("dbinom", "\\genfrac{(}{)}{0pt}{}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("tbinom", "\\genfrac{(}{)}{0pt}{1}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("pmod", "\\qquad\\mathbin{(\\mathrm{mod}\\ #1)}", 1);
        NewCommandMacro.addNewCommand("mod", "\\qquad\\mathbin{\\mathrm{mod}\\ #1}", 1);
        NewCommandMacro.addNewCommand("pod", "\\qquad\\mathbin{(#1)}", 1);
        NewCommandMacro.addNewCommand("dddot", "\\mathop{#1}\\limits^{...}", 1);
        NewCommandMacro.addNewCommand("ddddot", "\\mathop{#1}\\limits^{....}", 1);
        NewCommandMacro.addNewCommand("spdddot", "^{\\mathrm{...}}", 0);
        NewCommandMacro.addNewCommand("spbreve", "^{\\makeatletter\\sp@breve\\makeatother}", 0);
        NewCommandMacro.addNewCommand("sphat", "^{\\makeatletter\\sp@hat\\makeatother}", 0);
        NewCommandMacro.addNewCommand("spddot", "^{\\displaystyle..}", 0);
        NewCommandMacro.addNewCommand("spcheck", "^{\\vee}", 0);
        NewCommandMacro.addNewCommand("sptilde", "^{\\sim}", 0);
        NewCommandMacro.addNewCommand("spdot", "^{\\displaystyle.}", 0);
        NewCommandMacro.addNewCommand("d", "\\underaccent{\\dot}{#1}", 1);
        NewCommandMacro.addNewCommand("b", "\\underaccent{\\bar}{#1}", 1);
        NewCommandMacro.addNewCommand("Bra", "\\left\\langle{#1}\\right\\vert", 1);
        NewCommandMacro.addNewCommand("Ket", "\\left\\vert{#1}\\right\\rangle", 1);
        NewCommandMacro.addNewCommand("textsuperscript", "{}^{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textsubscript", "{}_{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textit", "\\mathit{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textbf", "\\mathbf{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textsf", "\\mathsf{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("texttt", "\\mathtt{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textrm", "\\text{#1}", 1);
        NewCommandMacro.addNewCommand("degree", "^\\circ", 0);
    }
}

