/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;

public class XLeftRightArrowFactory {
    private static final Atom MINUS = new TeXFormula((String)"-").root;
    private static final Atom LEFT = new TeXFormula((String)"\\leftarrow").root;
    private static final Atom RIGHT = new TeXFormula((String)"\\rightarrow").root;

    public static Box create(boolean left, TeXEnvironment env, float width) {
        float w;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box arr = left ? LEFT.createBox(env) : RIGHT.createBox(env);
        float swidth = arr.getWidth();
        if (width <= swidth) {
            return arr;
        }
        Box minus = new SmashedAtom(MINUS, "").createBox(env);
        Box kern = new SpaceAtom(5, -3.4f, 0.0f, 0.0f).createBox(env);
        float mwidth = minus.getWidth() + kern.getWidth();
        swidth += kern.getWidth();
        HorizontalBox hb = new HorizontalBox();
        for (w = 0.0f; w < width - swidth - mwidth; w += mwidth) {
            hb.add(minus);
            hb.add(kern);
        }
        hb.add(new ScaleAtom(MINUS, (width - swidth - w) / minus.getWidth(), 1.0).createBox(env));
        if (left) {
            hb.add(0, new SpaceAtom(5, -2.8f, 0.0f, 0.0f).createBox(env));
            hb.add(0, arr);
        } else {
            hb.add(new SpaceAtom(5, -1.8f, 0.0f, 0.0f).createBox(env));
            hb.add(arr);
        }
        return hb;
    }

    public static Box create(TeXEnvironment env, float width) {
        float w;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box left = LEFT.createBox(env);
        Box right = RIGHT.createBox(env);
        float swidth = left.getWidth() + right.getWidth();
        if (width < swidth) {
            HorizontalBox hb = new HorizontalBox(left);
            hb.add(new StrutBox(-Math.min(swidth - width, left.getWidth()), 0.0f, 0.0f, 0.0f));
            hb.add(right);
            return hb;
        }
        Box minus = new SmashedAtom(MINUS, "").createBox(env);
        Box kern = new SpaceAtom(5, -3.4f, 0.0f, 0.0f).createBox(env);
        float mwidth = minus.getWidth() + kern.getWidth();
        swidth += 2.0f * kern.getWidth();
        HorizontalBox hb = new HorizontalBox();
        for (w = 0.0f; w < width - swidth - mwidth; w += mwidth) {
            hb.add(minus);
            hb.add(kern);
        }
        hb.add(new ScaleBox(minus, (width - swidth - w) / minus.getWidth(), 1.0));
        hb.add(0, kern);
        hb.add(0, left);
        hb.add(kern);
        hb.add(right);
        return hb;
    }
}

