/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigOperatorAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXFormula;

public class TeXParser {
    public TeXFormula formula;
    private StringBuffer parseString;
    private int pos;
    private int spos;
    private int line = 0;
    private int col = 0;
    private int len;
    private int group = 0;
    private boolean insertion = false;
    private int atIsLetter = 0;
    private boolean arrayMode = false;
    private boolean ignoreWhiteSpace = true;
    private static final char ESCAPE = '\\';
    private static final char L_GROUP = '{';
    private static final char R_GROUP = '}';
    private static final char L_BRACK = '[';
    private static final char R_BRACK = ']';
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    private static final char SUB_SCRIPT = '_';
    private static final char SUPER_SCRIPT = '^';
    private static final char PRIME = '\'';
    private static final char DEGRE = '\u00b0';
    private static final char SQUARE = '\u00b2';
    private static final char CUBE = '\u00b3';
    private static final char ONE = '\u00b9';
    protected static boolean isLoading = false;

    public TeXParser(String parseString, TeXFormula formula) {
        this(parseString, formula, true);
    }

    public TeXParser(String parseString, TeXFormula formula, boolean firstpass) {
        this.formula = formula;
        if (parseString != null) {
            this.parseString = new StringBuffer(parseString);
            this.len = parseString.length();
            this.pos = 0;
            if (firstpass) {
                this.firstpass();
            }
        } else {
            this.parseString = null;
            this.pos = 0;
            this.len = 0;
        }
    }

    public TeXParser(String parseString, ArrayOfAtoms aoa, boolean firstpass) {
        this(parseString, (TeXFormula)aoa, firstpass);
        this.arrayMode = true;
    }

    public TeXParser(String parseString, TeXFormula formula, boolean firstpass, boolean space) {
        this(parseString, formula, firstpass);
        this.ignoreWhiteSpace = space;
    }

    public void reset(String latex) {
        this.parseString = new StringBuffer(latex);
        this.len = this.parseString.length();
        this.formula.root = null;
        this.pos = 0;
        this.spos = 0;
        this.line = 0;
        this.col = 0;
        this.group = 0;
        this.insertion = false;
        this.atIsLetter = 0;
        this.arrayMode = false;
        this.ignoreWhiteSpace = true;
        this.firstpass();
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.pos - this.col - 1;
    }

    public Atom getLastAtom() {
        Atom at = this.formula.root;
        if (at instanceof RowAtom) {
            return ((RowAtom)at).getLastAtom();
        }
        this.formula.root = null;
        return at;
    }

    public Atom getFormulaAtom() {
        Atom at = this.formula.root;
        this.formula.root = null;
        return at;
    }

    public void addAtom(Atom at) {
        this.formula.add(at);
    }

    public void makeAtLetter() {
        ++this.atIsLetter;
    }

    public void makeAtOther() {
        --this.atIsLetter;
    }

    public boolean isAtLetter() {
        return this.atIsLetter != 0;
    }

    public boolean isArrayMode() {
        return this.arrayMode;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public int getPos() {
        return this.pos;
    }

    public int rewind(int n) {
        this.pos -= n;
        return this.pos;
    }

    public void addRow() throws ParseException {
        if (!this.arrayMode) {
            throw new ParseException("You can add a row only in array mode !");
        }
        ((ArrayOfAtoms)this.formula).addRow();
    }

    private void firstpass() throws ParseException {
        if (this.len != 0) {
            block8: while (this.pos < this.len) {
                char ch = this.parseString.charAt(this.pos);
                switch (ch) {
                    case '\\': {
                        MacroInfo mac;
                        String[] args;
                        int spos = this.pos;
                        String com = this.getCommand();
                        if ("newcommand".equals(com) || "renewcommand".equals(com)) {
                            args = this.getOptsArgs(2, 2);
                            mac = MacroInfo.Commands.get(com);
                            mac.invoke(this, args);
                            this.parseString.delete(spos, this.pos);
                            this.len = this.parseString.length();
                            this.pos = spos;
                            continue block8;
                        }
                        if (NewCommandMacro.isMacro(com)) {
                            mac = MacroInfo.Commands.get(com);
                            args = this.getOptsArgs(mac.nbArgs, mac.hasOptions ? 1 : 0);
                            args[0] = com;
                            this.parseString.replace(spos, this.pos, (String)mac.invoke(this, args));
                            this.len = this.parseString.length();
                            this.pos = spos;
                            continue block8;
                        }
                        if ("begin".equals(com)) {
                            args = this.getOptsArgs(1, 0);
                            mac = MacroInfo.Commands.get(args[1] + "@env");
                            if (mac == null) {
                                throw new ParseException("Unknown environment: " + args[1] + " at position " + this.getLine() + ":" + this.getCol());
                            }
                            String[] optarg = this.getOptsArgs(mac.nbArgs - 1, 0);
                            String grp = this.getGroup("\\begin{" + args[1] + "}", "\\end{" + args[1] + "}");
                            String expr = "\\makeatletter \\" + args[1] + "@env";
                            for (int i = 1; i <= mac.nbArgs - 1; ++i) {
                                expr = expr + "{" + optarg[i] + "}";
                            }
                            expr = expr + "{" + grp + "}\\makeatother";
                            this.parseString.replace(spos, this.pos, expr);
                            this.len = this.parseString.length();
                            this.pos = spos;
                            continue block8;
                        }
                        if ("makeatletter".equals(com)) {
                            ++this.atIsLetter;
                            continue block8;
                        }
                        if (!"makeatother".equals(com)) continue block8;
                        --this.atIsLetter;
                        continue block8;
                    }
                    case '\'': {
                        String pr = "^{";
                        int spos = this.pos;
                        while (this.pos < this.len && this.parseString.charAt(this.pos) == '\'') {
                            pr = pr + "\\prime";
                            ++this.pos;
                        }
                        this.parseString.replace(spos, this.pos, pr + "}");
                        this.len = this.parseString.length();
                        continue block8;
                    }
                    case '\u00b0': {
                        this.parseString.replace(this.pos, this.pos + 1, "^\\circ");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block8;
                    }
                    case '\u00b2': {
                        this.parseString.replace(this.pos, this.pos + 1, "^2");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block8;
                    }
                    case '\u00b3': {
                        this.parseString.replace(this.pos, this.pos + 1, "^3");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block8;
                    }
                    case '\u00b9': {
                        this.parseString.replace(this.pos, this.pos + 1, "^1");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block8;
                    }
                }
                ++this.pos;
            }
            this.pos = 0;
            this.len = this.parseString.length();
        }
    }

    public void parse() throws ParseException {
        if (this.len != 0) {
            block10: while (this.pos < this.len) {
                char ch = this.parseString.charAt(this.pos);
                block0 : switch (ch) {
                    case '\n': {
                        ++this.line;
                        this.col = this.pos;
                    }
                    case '\t': 
                    case '\r': {
                        ++this.pos;
                        break;
                    }
                    case ' ': {
                        ++this.pos;
                        if (this.ignoreWhiteSpace) continue block10;
                        this.formula.add(new SpaceAtom());
                        while (this.pos < this.len && (ch = this.parseString.charAt(this.pos)) == ' ' && ch == '\t') {
                            if (ch != '\r') break block0;
                            ++this.pos;
                        }
                        continue block10;
                    }
                    case '\\': {
                        Atom at = this.processEscape();
                        this.formula.add(at);
                        if (this.arrayMode && at instanceof HlineAtom) {
                            ((ArrayOfAtoms)this.formula).addRow();
                        }
                        if (!this.insertion) continue block10;
                        this.insertion = false;
                        break;
                    }
                    case '{': {
                        this.formula.add(this.getArgument());
                        break;
                    }
                    case '}': {
                        --this.group;
                        ++this.pos;
                        if (this.group == -1) {
                            throw new ParseException("Found a closing '}' without an opening '{'!");
                        }
                        return;
                    }
                    case '^': 
                    case '_': {
                        this.formula.add(this.getScripts(ch));
                        break;
                    }
                    case '&': {
                        if (!this.arrayMode) {
                            throw new ParseException("Character '&' is only available in array mode !");
                        }
                        ((ArrayOfAtoms)this.formula).addCol();
                        ++this.pos;
                        break;
                    }
                    default: {
                        this.formula.add(this.convertCharacter(ch));
                        ++this.pos;
                    }
                }
            }
        }
    }

    private Atom getScripts(char f) throws ParseException {
        Atom at;
        ++this.pos;
        Atom first = this.getArgument();
        Atom second = null;
        char s = '\u0000';
        if (this.pos < this.len) {
            s = this.parseString.charAt(this.pos);
        }
        if (f == '_' && s == '_') {
            throw new ParseException("Consecutive subscripts are not allowed !");
        }
        if (f == '^' && s == '^') {
            throw new ParseException("Consecutive superscripts are not allowed !");
        }
        if (f == '_' && s == '^') {
            ++this.pos;
            second = this.getArgument();
        }
        if (f == '^' && s == '_') {
            ++this.pos;
            second = first;
            first = this.getArgument();
        }
        if (f == '^' && s != '_') {
            second = first;
            first = null;
        }
        if (this.formula.root instanceof RowAtom) {
            at = ((RowAtom)this.formula.root).getLastAtom();
        } else if (this.formula.root == null) {
            at = new PhantomAtom(new CharAtom('M', "mathnormal"), false, true, true);
        } else {
            at = this.formula.root;
            this.formula.root = null;
        }
        if (at.getRightType() == 1) {
            return new BigOperatorAtom(at, first, second);
        }
        if (at instanceof OverUnderDelimiter) {
            if (((OverUnderDelimiter)at).isOver()) {
                if (second != null) {
                    ((OverUnderDelimiter)at).addScript(second);
                    return new ScriptsAtom(at, first, null);
                }
            } else if (first != null) {
                ((OverUnderDelimiter)at).addScript(first);
                return new ScriptsAtom(at, null, second);
            }
        }
        return new ScriptsAtom(at, first, second);
    }

    public String getGroup(char open, char close) throws ParseException {
        if (this.pos == this.len) {
            return null;
        }
        char ch = this.parseString.charAt(this.pos);
        if (this.pos < this.len && ch == open) {
            int group = 1;
            int spos = this.pos;
            while (this.pos < this.len - 1 && group != 0) {
                ++this.pos;
                ch = this.parseString.charAt(this.pos);
                if (ch == open) {
                    ++group;
                    continue;
                }
                if (ch == close) {
                    --group;
                    continue;
                }
                if (ch != '\\') continue;
                ++this.pos;
            }
            if (group != 0) {
                throw new ParseException("Illegal end,  missing '" + close + "'!");
            }
            ++this.pos;
            return this.parseString.substring(spos + 1, this.pos - 1);
        }
        throw new ParseException("missing '" + open + "'!");
    }

    public String getGroup(String open, String close) throws ParseException {
        int group = 1;
        int ol = open.length();
        int cl = close.length();
        int oc = 0;
        int cc = 0;
        StringBuffer buf = new StringBuffer();
        while (this.pos < this.len && group != 0) {
            char c = this.parseString.charAt(this.pos);
            oc = c == open.charAt(oc) ? ++oc : 0;
            cc = c == close.charAt(cc) ? ++cc : 0;
            if (this.pos + 1 < this.len) {
                char c1 = this.parseString.charAt(this.pos + 1);
                if (oc == ol) {
                    if (!(c1 >= 'a' && c1 <= 'z' || c1 >= 'A' && c1 <= 'Z')) {
                        ++group;
                    }
                    oc = 0;
                }
                if (cc == cl) {
                    if (!(c1 >= 'a' && c1 <= 'z' || c1 >= 'A' && c1 <= 'Z')) {
                        --group;
                    }
                    cc = 0;
                }
            } else {
                if (oc == ol) {
                    ++group;
                    oc = 0;
                }
                if (cc == cl) {
                    --group;
                    cc = 0;
                }
            }
            buf.append(c);
            ++this.pos;
        }
        if (group != 0) {
            throw new ParseException("The token " + open + " must be closed by " + close);
        }
        return buf.substring(0, buf.length() - cl);
    }

    public Atom getArgument() throws ParseException {
        this.skipWhiteSpace();
        char ch = this.parseString.charAt(this.pos);
        if (ch == '{') {
            TeXFormula tf = new TeXFormula();
            TeXFormula sformula = this.formula;
            this.formula = tf;
            ++this.pos;
            ++this.group;
            this.parse();
            this.formula = sformula;
            if (this.formula.root == null) {
                RowAtom at = new RowAtom();
                at.add(tf.root);
                return at;
            }
            return tf.root;
        }
        if (ch == '\\') {
            Atom at = this.processEscape();
            if (this.insertion) {
                this.insertion = false;
                return this.getArgument();
            }
            return at;
        }
        ++this.pos;
        return this.convertCharacter(ch);
    }

    public String getOverArgument() throws ParseException {
        String str;
        if (this.pos == this.len) {
            return null;
        }
        int ogroup = 1;
        char ch = '\u0000';
        int spos = this.pos;
        while (this.pos < this.len && ogroup != 0) {
            ch = this.parseString.charAt(this.pos);
            switch (ch) {
                case '{': {
                    ++ogroup;
                    break;
                }
                case '&': {
                    if (ogroup != 1) break;
                    --ogroup;
                    break;
                }
                case '}': {
                    --ogroup;
                    break;
                }
                case '\\': {
                    ++this.pos;
                    if (this.pos < this.len && this.parseString.charAt(this.pos) == '\\' && ogroup == 1) {
                        --ogroup;
                        --this.pos;
                        break;
                    }
                    if (this.pos >= this.len - 1 || this.parseString.charAt(this.pos) != 'c' || this.parseString.charAt(this.pos + 1) != 'r' || ogroup != 1) break;
                    --ogroup;
                    --this.pos;
                }
            }
            ++this.pos;
        }
        if (ogroup >= 2) {
            throw new ParseException("Illegal end,  missing '}' !");
        }
        if (ogroup == 0) {
            str = this.parseString.substring(spos, this.pos - 1);
        } else {
            str = this.parseString.substring(spos, this.pos);
            ch = '\u0000';
        }
        if (ch == '&' || ch == '\\' || ch == '}') {
            --this.pos;
        }
        return str;
    }

    public Atom convertCharacter(char c) throws ParseException {
        if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            String symbolName;
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (!isLoading && !DefaultTeXFont.loadedAlphabets.contains(block)) {
                DefaultTeXFont.addAlphabet(DefaultTeXFont.registeredAlphabets.get(block));
            }
            if ((symbolName = TeXFormula.symbolMappings[c]) == null && (TeXFormula.symbolFormulaMappings == null || TeXFormula.symbolFormulaMappings[c] == null)) {
                throw new ParseException("Unknown character : '" + Character.toString(c) + "' (or " + c + ")");
            }
            if (TeXFormula.symbolFormulaMappings != null && TeXFormula.symbolFormulaMappings[c] != null) {
                return TeXFormula.symbolFormulaMappings[c];
            }
            try {
                return SymbolAtom.get(symbolName);
            }
            catch (SymbolNotFoundException e) {
                throw new ParseException("The character '" + Character.toString(c) + "' was mapped to an unknown symbol with the name '" + symbolName + "'!", e);
            }
        }
        return new CharAtom(c, this.formula.textStyle);
    }

    private String getCommand() {
        int spos = ++this.pos;
        char ch = '\u0000';
        while (this.pos < this.len && ((ch = this.parseString.charAt(this.pos)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || this.atIsLetter != 0 && ch == '@')) {
            ++this.pos;
        }
        if (ch == '\u0000') {
            throw new ParseException("An expression cannot be finished by a \\ !");
        }
        if (this.pos == spos) {
            ++this.pos;
        }
        return this.parseString.substring(spos, this.pos);
    }

    private Atom processEscape() throws ParseException {
        this.spos = this.pos;
        String command = this.getCommand();
        SymbolAtom s = null;
        TeXFormula predef = null;
        if (MacroInfo.Commands.get(command) != null) {
            return this.processCommands(command);
        }
        try {
            predef = TeXFormula.get(command);
            return predef.root;
        }
        catch (FormulaNotFoundException e) {
            try {
                s = SymbolAtom.get(command);
                return s;
            }
            catch (SymbolNotFoundException e1) {
                throw new ParseException("Unknown symbol or command or predefined TeXFormula: '" + command + "'");
            }
        }
    }

    private void insert(int beg, int end, String formula) {
        this.parseString.replace(beg, end, formula);
        this.len = this.parseString.length();
        this.pos = beg;
        this.insertion = true;
    }

    public String[] getOptsArgs(int nbArgs, int opts) {
        String[] args = new String[nbArgs + 10 + 1];
        if (nbArgs != 0) {
            if (opts == 1) {
                try {
                    for (int j = nbArgs + 1; j < nbArgs + 11; ++j) {
                        this.skipWhiteSpace();
                        args[j] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException e) {
                    args[j] = null;
                }
            }
            this.skipWhiteSpace();
            try {
                args[1] = this.getGroup('{', '}');
            }
            catch (ParseException e) {
                if (this.parseString.charAt(this.pos) != '\\') {
                    args[1] = "" + this.parseString.charAt(this.pos);
                    ++this.pos;
                }
                args[1] = this.getCommandWithArgs(this.getCommand());
            }
            if (opts == 2) {
                try {
                    for (int j = nbArgs + 1; j < nbArgs + 11; ++j) {
                        this.skipWhiteSpace();
                        args[j] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException e) {
                    args[j] = null;
                }
            }
            for (int i = 2; i <= nbArgs; ++i) {
                this.skipWhiteSpace();
                try {
                    args[i] = this.getGroup('{', '}');
                    continue;
                }
                catch (ParseException e) {
                    if (this.parseString.charAt(this.pos) != '\\') {
                        args[i] = "" + this.parseString.charAt(this.pos);
                        ++this.pos;
                        continue;
                    }
                    args[i] = this.getCommandWithArgs(this.getCommand());
                }
            }
            this.skipWhiteSpace();
        }
        return args;
    }

    private String getCommandWithArgs(String command) {
        if (command.equals("left")) {
            return this.getGroup("\\left", "\\right");
        }
        MacroInfo mac = MacroInfo.Commands.get(command);
        if (mac != null) {
            String arg_t;
            int j;
            int mac_opts = 0;
            if (mac.hasOptions) {
                mac_opts = mac.posOpts;
            }
            String[] mac_args = this.getOptsArgs(mac.nbArgs, mac_opts);
            StringBuffer mac_arg = new StringBuffer("\\");
            mac_arg.append(command);
            for (j = 0; j < mac.posOpts; ++j) {
                arg_t = mac_args[mac.nbArgs + j + 1];
                if (arg_t == null) continue;
                mac_arg.append("[").append(arg_t).append("]");
            }
            for (j = 0; j < mac.nbArgs; ++j) {
                arg_t = mac_args[j + 1];
                if (arg_t == null) continue;
                mac_arg.append("{").append(arg_t).append("}");
            }
            return mac_arg.toString();
        }
        return "\\" + command;
    }

    private Atom processCommands(String command) throws ParseException {
        MacroInfo mac = MacroInfo.Commands.get(command);
        int opts = 0;
        if (mac.hasOptions) {
            opts = mac.posOpts;
        }
        String[] args = this.getOptsArgs(mac.nbArgs, opts);
        args[0] = command;
        if (NewCommandMacro.isMacro(command)) {
            String ret = (String)mac.invoke(this, args);
            this.insert(this.spos, this.pos, ret);
            return null;
        }
        return (Atom)mac.invoke(this, args);
    }

    public boolean isValidName(String com) {
        char c = '\u0000';
        if (com.charAt(0) == '\\') {
            int len = com.length();
            for (int pos = 1; pos < len && (Character.isLetter(c = com.charAt(pos)) || this.atIsLetter != 0 && c == '@'); ++pos) {
            }
        } else {
            return false;
        }
        return Character.isLetter(c);
    }

    private void skipWhiteSpace() {
        char c;
        while (this.pos < this.len && ((c = this.parseString.charAt(this.pos)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            if (c == '\n') {
                ++this.line;
                this.col = this.pos;
            }
            ++this.pos;
        }
    }
}

