/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidAtomTypeException;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PredefinedTeXFormulaParser;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormulaSettingsParser;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.VCenteredAtom;

public class TeXFormula {
    public static final String VERSION = "0.9.3";
    private static final String[][] delimiterNames = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    protected static final float PREC = 1.0E-7f;
    public static Map<String, TeXFormula> predefinedTeXFormulas = new HashMap<String, TeXFormula>();
    public static String[] symbolMappings;
    public static Atom[] symbolFormulaMappings;
    public List<MiddleAtom> middle = new LinkedList<MiddleAtom>();
    private TeXParser parser;
    public Atom root = null;
    public String textStyle = null;
    public boolean isColored = false;

    public static void addSymbolMappings(String file) throws ResourceParseException {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceParseException(file, e);
        }
        TeXFormula.addSymbolMappings(in, file);
    }

    public static void addSymbolMappings(InputStream in, String name) throws ResourceParseException {
        TeXFormulaSettingsParser tfsp = new TeXFormulaSettingsParser(in, name);
        tfsp.parseSymbolMappings(symbolMappings);
        tfsp.parseSymbolToFormulaMappings(symbolFormulaMappings);
    }

    public TeXFormula() {
        this.parser = new TeXParser("", this, false);
    }

    public TeXFormula(String s) throws ParseException {
        this(s, null);
    }

    public TeXFormula(String s, boolean firstpass) throws ParseException {
        this.textStyle = null;
        this.parser = new TeXParser(s, this, firstpass);
        if (s != null && s.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula(String s, String textStyle) throws ParseException {
        this.textStyle = textStyle;
        this.parser = new TeXParser(s, this);
        if (s != null && s.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula(String s, String textStyle, boolean firstpass, boolean space) throws ParseException {
        this.textStyle = textStyle;
        this.parser = new TeXParser(s, this, firstpass, space);
        if (s != null && s.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula(TeXFormula f) {
        if (f != null) {
            this.addImpl(f);
        }
    }

    public static void registerFonts(boolean b) {
        DefaultTeXFontParser.registerFonts(b);
    }

    public void setLaTeX(String ltx) throws ParseException {
        this.parser.reset(ltx);
        if (ltx != null && ltx.length() != 0) {
            this.parser.parse();
        }
    }

    public TeXFormula add(Atom el) {
        if (el != null) {
            if (el instanceof MiddleAtom) {
                this.middle.add((MiddleAtom)el);
            }
            if (this.root == null) {
                this.root = el;
            } else {
                if (!(this.root instanceof RowAtom)) {
                    this.root = new RowAtom(this.root);
                }
                ((RowAtom)this.root).add(el);
            }
        }
        return this;
    }

    public TeXFormula add(String s) throws ParseException {
        if (s != null && s.length() != 0) {
            this.textStyle = null;
            this.add(new TeXFormula(s));
        }
        return this;
    }

    public TeXFormula append(String s) throws ParseException {
        if (s != null && s.length() != 0) {
            TeXParser tp = new TeXParser(s, this);
            tp.parse();
        }
        return this;
    }

    public TeXFormula add(TeXFormula f) {
        this.addImpl(f);
        return this;
    }

    private void addImpl(TeXFormula f) {
        if (f.root != null) {
            if (f.root instanceof RowAtom) {
                this.add(new RowAtom(f.root));
            } else {
                this.add(f.root);
            }
        }
    }

    public void setLookAtLastAtom(boolean b) {
        if (this.root instanceof RowAtom) {
            ((RowAtom)this.root).lookAtLastAtom = b;
        }
    }

    public boolean getLookAtLastAtom() {
        if (this.root instanceof RowAtom) {
            return ((RowAtom)this.root).lookAtLastAtom;
        }
        return false;
    }

    public TeXFormula centerOnAxis() {
        this.root = new VCenteredAtom(this.root);
        return this;
    }

    public static void addPredefinedTeXFormula(InputStream xmlFile) throws ResourceParseException {
        new PredefinedTeXFormulaParser(xmlFile, "TeXFormula").parse(predefinedTeXFormulas);
    }

    public static void addPredefinedCommands(InputStream xmlFile) throws ResourceParseException {
        new PredefinedTeXFormulaParser(xmlFile, "Command").parse(MacroInfo.Commands);
    }

    public TeXFormula addStrut(int unit, float width, float height, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(unit, width, height, depth));
    }

    public TeXFormula addStrut(int type) throws InvalidUnitException {
        return this.add(new SpaceAtom(type));
    }

    public TeXFormula addStrut(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(widthUnit, width, heightUnit, height, depthUnit, depth));
    }

    private Box createBox(TeXEnvironment style) {
        if (this.root == null) {
            return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.root.createBox(style);
    }

    public TeXIcon createTeXIcon(int style, float size) {
        TeXEnvironment te = new TeXEnvironment(style, new DefaultTeXFont(size));
        Box box = this.createBox(te);
        TeXIcon ti = new TeXIcon(box, size);
        ti.isColored = te.isColored;
        return ti;
    }

    public TeXIcon createTeXIcon(int style, float size, boolean trueValues) {
        TeXEnvironment te = new TeXEnvironment(style, new DefaultTeXFont(size));
        Box box = this.createBox(te);
        TeXIcon ti = new TeXIcon(box, size, trueValues);
        ti.isColored = te.isColored;
        return ti;
    }

    public TeXIcon createTeXIcon(int style, float size, int widthUnit, float textwidth, int align) {
        TeXEnvironment te = new TeXEnvironment(style, (TeXFont)new DefaultTeXFont(size), widthUnit, textwidth);
        Box box = this.createBox(te);
        HorizontalBox hb = new HorizontalBox(box, te.getTextwidth(), align);
        TeXIcon ti = new TeXIcon(hb, size, true);
        ti.isColored = te.isColored;
        return ti;
    }

    public void createImage(String format, int style, float size, String out, Color bg, Color fg, boolean transparency) {
        TeXIcon icon = this.createTeXIcon(style, size);
        icon.setInsets(new Insets(1, 1, 1, 1));
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, transparency ? 2 : 1);
        Graphics2D g2 = image.createGraphics();
        if (bg != null && !transparency) {
            g2.setColor(bg);
            g2.fillRect(0, 0, w, h);
        }
        icon.setForeground(fg);
        icon.paintIcon(null, g2, 0, 0);
        try {
            FileImageOutputStream imout = new FileImageOutputStream(new File(out));
            ImageIO.write((RenderedImage)image, format, imout);
            imout.flush();
            imout.close();
        }
        catch (IOException ex) {
            System.err.println("I/O error : Cannot generate " + out);
        }
        g2.dispose();
    }

    public void createPNG(int style, float size, String out, Color bg, Color fg) {
        this.createImage("png", style, size, out, bg, fg, bg == null);
    }

    public void createGIF(int style, float size, String out, Color bg, Color fg) {
        this.createImage("gif", style, size, out, bg, fg, bg == null);
    }

    public void createJPEG(int style, float size, String out, Color bg, Color fg) {
        this.createImage("jpeg", style, size, out, bg, fg, false);
    }

    public void setDEBUG(boolean b) {
        Box.DEBUG = b;
    }

    public TeXFormula setBackground(Color c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(c, null, (ColorAtom)this.root) : new ColorAtom(this.root, c, null);
        }
        return this;
    }

    public TeXFormula setColor(Color c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(null, c, (ColorAtom)this.root) : new ColorAtom(this.root, null, c);
        }
        return this;
    }

    public TeXFormula setFixedTypes(int leftType, int rightType) throws InvalidAtomTypeException {
        this.root = new TypedAtom(leftType, rightType, this.root);
        return this;
    }

    public static TeXFormula get(String name) throws FormulaNotFoundException {
        TeXFormula formula = predefinedTeXFormulas.get(name);
        if (formula == null) {
            throw new FormulaNotFoundException(name);
        }
        return new TeXFormula(formula);
    }

    static {
        TeXFormulaSettingsParser parser = new TeXFormulaSettingsParser();
        symbolMappings = parser.parseSymbolMappings();
        try {
            new PredefinedTeXFormulaParser("PredefinedCommands.xml", "Command").parse(MacroInfo.Commands);
            new PredefinedTeXFormulaParser("PredefinedTeXFormulas.xml", "TeXFormula").parse(predefinedTeXFormulas);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        symbolFormulaMappings = parser.parseSymbolToFormulaMappings();
        try {
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.cyrillic.CyrillicRegistration").newInstance());
            DefaultTeXFont.registerAlphabet((AlphabetRegistration)Class.forName("org.scilab.forge.jlatexmath.greek.GreekRegistration").newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

