/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXFont;

public class TeXEnvironment {
    private Color background = null;
    private Color color = null;
    private int style = 0;
    private TeXFont tf;
    private int lastFontId = -1;
    private float textwidth = Float.POSITIVE_INFINITY;
    public boolean isColored = false;

    public TeXEnvironment(int style, TeXFont tf) {
        this(style, tf, null, null);
    }

    public TeXEnvironment(int style, TeXFont tf, int widthUnit, float textwidth) {
        this(style, tf, null, null);
        this.textwidth = new SpaceAtom(widthUnit, textwidth, 0.0f, 0.0f).createBox(this).getWidth();
    }

    private TeXEnvironment(int style, TeXFont tf, Color bg, Color c) {
        this.style = style;
        this.tf = tf;
        this.background = bg;
        this.color = c;
    }

    public void setTextwidth(int widthUnit, float textwidth) {
        this.textwidth = new SpaceAtom(widthUnit, textwidth, 0.0f, 0.0f).createBox(this).getWidth();
    }

    public float getTextwidth() {
        return this.textwidth;
    }

    protected TeXEnvironment copy() {
        return new TeXEnvironment(this.style, this.tf, this.background, this.color);
    }

    protected TeXEnvironment copy(TeXFont tf) {
        TeXEnvironment te = new TeXEnvironment(this.style, tf, this.background, this.color);
        te.textwidth = this.textwidth;
        return te;
    }

    public TeXEnvironment crampStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style % 2 == 1 ? this.style : this.style + 1;
        return s;
    }

    public TeXEnvironment denomStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 2) + 1 + 2 - 2 * (this.style / 6);
        return s;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.color;
    }

    public float getSize() {
        return this.tf.getSize();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public TeXFont getTeXFont() {
        return this.tf;
    }

    public TeXEnvironment numStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style + 2 - 2 * (this.style / 6);
        return s;
    }

    public void reset() {
        this.color = null;
        this.background = null;
    }

    public TeXEnvironment rootStyle() {
        TeXEnvironment s = this.copy();
        s.style = 6;
        return s;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public TeXEnvironment subStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + 1;
        return s;
    }

    public TeXEnvironment supStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + this.style % 2;
        return s;
    }

    public float getSpace() {
        return this.tf.getSpace(this.style);
    }

    public void setLastFontId(int id) {
        this.lastFontId = id;
    }

    public int getLastFontId() {
        return this.lastFontId == -1 ? this.tf.getMuFontId() : this.lastFontId;
    }
}

