/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import org.scilab.forge.jlatexmath.Box;

public class RotateBox
extends Box {
    protected double angle = 0.0;
    private Box box;
    private float xmax;
    private float xmin;
    private float ymax;
    private float ymin;

    public RotateBox(Box b, double angle) {
        this.box = b;
        this.angle = angle = angle * Math.PI / 180.0;
        this.height = b.height;
        this.depth = b.depth;
        this.width = b.width;
        float s = (float)Math.sin(angle);
        float c = (float)Math.cos(angle);
        this.xmax = Math.max(-this.height * s, Math.max(this.depth * s, Math.max(this.width * c + this.depth * s, this.width * c - this.height * s)));
        this.xmin = Math.min(-this.height * s, Math.min(this.depth * s, Math.min(this.width * c + this.depth * s, this.width * c - this.height * s)));
        this.ymax = Math.max(this.height * c, Math.max(-this.depth * c, Math.max(this.width * s - this.depth * c, this.width * s + this.height * c)));
        this.ymin = Math.min(this.height * c, Math.min(-this.depth * c, Math.min(this.width * s - this.depth * c, this.width * s + this.height * c)));
        this.width = this.xmax - this.xmin;
        this.height = this.ymax;
        this.depth = -this.ymin;
    }

    public void draw(Graphics2D g2, float x, float y) {
        g2.rotate(-this.angle, x -= this.xmin, y);
        this.box.draw(g2, x, y);
        g2.rotate(this.angle, x, y);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

