/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;

public class HdotsforAtom
extends MulticolumnAtom {
    private static final Atom ldotp = new TeXFormula((String)"\\ldotp").root;
    private static final Atom thin = new TeXFormula((String)"\\,").root;
    private float coeff;

    public HdotsforAtom(int n, float coeff) {
        super(n, "c", ldotp);
        this.coeff = coeff;
    }

    public Box createBox(TeXEnvironment env) {
        HorizontalBox b;
        StrutBox sp = new StrutBox(this.coeff * thin.createBox(env).getWidth(), 0.0f, 0.0f, 0.0f);
        HorizontalBox db = new HorizontalBox(sp);
        db.add(ldotp.createBox(env));
        db.add(sp);
        if (this.w != 0.0f) {
            float dw = db.getWidth();
            b = new HorizontalBox(db);
            while (b.getWidth() < this.w) {
                ((Box)b).add(db);
            }
            b = new HorizontalBox(b, this.w, 2);
        } else {
            b = db;
        }
        b.type = 12;
        return b;
    }
}

