/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.GraphicsBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;

public class GraphicsAtom
extends Atom {
    private Image image = null;
    private BufferedImage bimage;
    private Label c;
    private int w;
    private int h;

    public GraphicsAtom(String path) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                URL url = new URL(path);
                this.image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException e) {
                this.image = null;
            }
        } else {
            this.image = Toolkit.getDefaultToolkit().getImage(path);
        }
        if (this.image != null) {
            this.c = new Label();
            MediaTracker tracker = new MediaTracker(this.c);
            tracker.addImage(this.image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                this.image = null;
            }
        }
        this.draw();
    }

    public void draw() {
        if (this.image != null) {
            this.w = this.image.getWidth(this.c);
            this.h = this.image.getHeight(this.c);
            this.bimage = new BufferedImage(this.w, this.h, 2);
            Graphics2D g2d = this.bimage.createGraphics();
            g2d.drawImage(this.image, 0, 0, null);
            g2d.dispose();
        }
    }

    public Box createBox(TeXEnvironment env) {
        if (this.image != null) {
            env.isColored = true;
            float width = new SpaceAtom(2, this.w, 0.0f, 0.0f).createBox(env).getWidth();
            float height = new SpaceAtom(2, this.h, 0.0f, 0.0f).createBox(env).getWidth();
            return new GraphicsBox(this.bimage, this.w, this.h, width, height);
        }
        return new TeXFormula((String)"\\text{ No such image file ! }").root.createBox(env);
    }
}

