/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.FramedBox;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class FBoxAtom
extends Atom {
    public static SpaceAtom hsep = new SpaceAtom(0, 0.5f, 0.0f, 0.0f);
    public static SpaceAtom vsep = new SpaceAtom(1, 0.0f, 0.5f, 0.0f);
    private final Atom base;
    private Color bg = null;
    private Color line = null;

    public FBoxAtom(Atom base) {
        if (base == null) {
            this.base = new RowAtom();
        } else {
            this.base = base;
            this.type = base.type;
        }
    }

    public FBoxAtom(Atom base, Color bg, Color line) {
        this(base);
        this.bg = bg;
        this.line = line;
    }

    public Box createBox(TeXEnvironment env) {
        Box Hsep = hsep.createBox(env);
        Box Vsep = vsep.createBox(env);
        Box bbase = this.base.createBox(env);
        HorizontalBox hb = new HorizontalBox(Hsep);
        hb.add(bbase);
        hb.add(Hsep);
        VerticalBox vb = new VerticalBox();
        vb.add(Vsep);
        vb.add(hb);
        vb.add(Vsep);
        vb.setHeight(bbase.getHeight() + Vsep.getHeight());
        vb.setDepth(bbase.getDepth() + Vsep.getHeight());
        float drt = env.getTeXFont().getDefaultRuleThickness(env.getStyle());
        if (this.bg == null) {
            return new FramedBox(vb, drt);
        }
        env.isColored = true;
        HorizontalBox hbb = new HorizontalBox(env.getColor(), this.bg);
        hbb.add(vb);
        return new FramedBox(hbb, drt, this.line);
    }
}

